<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');
$routes->get('probar-planes', 'ModeloController::planes');

// --- SECCIÓN DE AUTENTICACIÓN ---
$routes->get('login', 'Auth::login'); 
$routes->post('auth/login', 'Auth::login'); 
$routes->get('logout', 'Auth::logout');

// --- SECCIÓN DE REGISTRO PÚBLICO ---
$routes->get('registro', 'Auth::register');         // URL amigable
$routes->post('registro/registrar', 'Auth::register'); // Acción del formulario

// --- SECCIÓN ADMINISTRATIVA ---
$routes->group('admin', ['filter' => 'auth:admin'], function($routes) {
    $routes->get('dashboard', 'Admin::index');
    $routes->get('verificaciones', 'Admin\Modelos::verificaciones'); 
    $routes->post('rechazar-modelo/(:num)', 'Admin\Modelos::rechazar/$1');
    $routes->get('validar-modelo/(:num)', 'Admin\Modelos::validar/$1');
    $routes->get('resenas', 'Admin\Modelos::resenas');
    $routes->get('aprobar-resena/(:num)', 'Admin\Modelos::aprobarResena/$1');
    $routes->get('eliminar-resena/(:num)', 'Admin\Modelos::eliminarResena/$1');
    $routes->get('modelos', 'Admin\Modelos::index');
    $routes->get('modelos/nuevo', 'Admin\Modelos::nuevo');
    $routes->post('modelos/guardar', 'Admin\Modelos::guardar');
    $routes->get('pagos', 'Admin\Modelos::pagos'); 
    $routes->get('modelos', 'Admin\Modelos::index');
    $routes->post('activar-plan/(:num)', 'Admin\Modelos::activarPlan/$1');

});

// --- SECCIÓN DE AUTOGESTIÓN PARA MODELOS ---
// Todas las rutas que empiezan con "modelo/..." y son para la modelo logueada van AQUÍ
$routes->group('modelo', ['filter' => 'auth:modelo'], function($routes) {
    $routes->get('dashboard', 'ModeloController::index'); 
    $routes->get('editar-ficha', 'ModeloController::publicar'); 
    $routes->post('guardar-ficha', 'ModeloController::guardarFicha');
    $routes->get('planes', 'ModeloController::planes');
    $routes->get('historias', 'ModeloController::verHistorias');
    $routes->post('subir-historia', 'ModeloController::subirHistoria');
    $routes->get('eliminar-historia/(:num)', 'ModeloController::eliminarHistoria/$1');
    $routes->get('eliminar-media/(:num)', 'ModeloController::eliminarMedia/$1');
    $routes->post('subir-verificacion', 'ModeloController::subirVerificacion');
    $routes->post('actualizar-disponibilidad', 'ModeloController::actualizarDisponibilidad');
});

// --- SECCIÓN PARA USUARIOS (CLIENTES) ---
$routes->group('usuario', ['filter' => 'auth:usuario'], function($routes) {
    $routes->get('panel', 'UsuarioController::index'); 
    $routes->post('actualizar', 'UsuarioController::actualizar');
    // NUEVAS RUTAS
    $routes->get('favoritas', 'UsuarioController::favoritas'); // Para ver la lista de guardadas
    $routes->get('toggle-favorito/(:num)', 'UsuarioController::toggleFavorito/$1'); // Para el clic del corazón
});

// --- RUTAS PÚBLICAS Y API ---
$routes->get('buscar', 'Home::buscar');
$routes->get('api/get-ciudades/(:num)', 'Api::getCiudades/$1');
$routes->post('api/registrar-clic', 'Home::registrarClic');
$routes->post('modelo/dejar-resena', 'UsuarioController::guardarResena');

// ESTA RUTA SIEMPRE AL FINAL: Es el perfil público
// Si alguien entra a modelo/planes, el sistema buscará primero en el grupo de arriba.
// Si no lo encuentra arriba, recién ahí intentará buscar un perfil con esta ruta.
$routes->get('modelo/(:segment)', 'Home::perfil/$1');

$routes->get('auth/recuperar', 'Auth::recuperar');
$routes->post('auth/enviar-token', 'Auth::enviarToken');
$routes->get('auth/restablecer/(:any)', 'Auth::restablecer/$1');
$routes->post('auth/actualizar-password', 'Auth::actualizarPassword');

/*
$routes->get('admin/hard-reset-sistema', 'Admin\Mantenimiento::resetSistema');
*/
