<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\ModeloModel;

class Modelos extends BaseController
{
    protected $modeloModel;

    public function __construct() {
        $this->modeloModel = new ModeloModel();
        helper('email');
    }

    public function index() {
        // 1. Traer los datos de la sesin para el Layout
    $data['usuario'] = session()->get('nombre'); 
    $data['rol']     = session()->get('rol'); // O como se llame tu variable de rol en la sesin
    
        // Traemos todas las modelos, uniendo con la tabla de usuarios para ver su nombre real/email
        $data['modelos'] = $this->modeloModel->select('modelos.*, usuarios.nombre as usuario_nombre, usuarios.email')
            ->join('usuarios', 'usuarios.id = modelos.usuario_id')
            ->orderBy('modelos.created_at', 'DESC')
            ->findAll();

        $data['titulo'] = "Gesti&oacute;n de Modelos";
        return view('admin/modelos/index', $data);
    }

    public function nuevo() {
        $data = [
            'titulo'  => 'Agregar Nueva Modelo',
            'usuario' => session()->get('nombre'),
            'rol'     => session()->get('rol')
        ];
        return view('admin/modelos/crear', $data);
    }
       public function verificaciones() {
        $data = [
            'usuario' => session()->get('nombre'),
            'rol'     => session()->get('rol'),
            'titulo'  => 'Centro de Verificaciones Premium'
        ];
    
        // MODIFICACI07N: Agregamos condiciones estrictas para que NO sea NULL ni est vaco
        $data['modelos'] = $this->modeloModel->where('verificada', 0)
            ->where('documento_identidad IS NOT NULL') // No es nulo
            ->where('documento_identidad !=', '')       // No est vaco
            ->where('selfie_verificacion IS NOT NULL')  // Lo mismo para la selfie
            ->where('selfie_verificacion !=', '')
            ->findAll();
    
        $data['historial'] = $this->modeloModel->where('verificada', 1)
            ->orderBy('updated_at', 'DESC')
            ->limit(5)
            ->findAll();
    
        return view('admin/verificaciones/index', $data);
    }

    // En app/Controllers/Admin/Modelos.php

    public function validar($id) {
    $modelo = $this->modeloModel->select('modelos.*, usuarios.email, usuarios.nombre as u_nombre')
                                ->join('usuarios', 'usuarios.id = modelos.usuario_id')
                                ->find($id);

    if (!$modelo) return redirect()->back()->with('error', 'Modelo no encontrada.');

    // Actualizamos el estado
    $this->modeloModel->update($id, [
        'verificada' => 1,
        'observaciones_admin' => null 
    ]);

    // Preparamos datos para la plantilla
    $emailData = [
        'nombre' => $modelo['nombre_artistico'] ?: $modelo['u_nombre'],
        'email'  => $modelo['email']
    ];
    
    // Quitamos el emoji del asunto para evitar el error de iconv_strlen
    $asunto = 'Tu perfil ha sido verificado - Calientitas'; 
    
    helper('email');
    enviar_notificacion($modelo['email'], $asunto, 'ficha_aprobada', $emailData);
    
    return redirect()->to(base_url('admin/verificaciones'))->with('success', 'Modelo verificada correctamente.');
    }

    public function rechazar($id) {
    $motivo = $this->request->getPost('motivo_rechazo');
    if (empty($motivo)) $motivo = "Los documentos no son claros o no cumplen con los requisitos.";

    // Buscamos los datos incluyendo el email del usuario
    $modelo = $this->modeloModel->select('modelos.*, usuarios.email, usuarios.nombre as u_nombre')
                                ->join('usuarios', 'usuarios.id = modelos.usuario_id')
                                ->find($id);

    if (!$modelo) return redirect()->back()->with('error', 'Modelo no encontrada.');

    // ACTUALIZACI07N CR01TICA: Limpiamos los campos para que la vista de la modelo se resetee
    $this->modeloModel->update($id, [
        'documento_identidad' => '', // Usamos string vaco en lugar de null para evitar errores de BD
        'selfie_verificacion' => '',
        'verificada'          => 0,  // Vuelve a estado inicial
        'observaciones_admin' => $motivo
    ]);

    // Preparamos los datos exactamente como los pide tu plantilla
    $emailData = [
        'nombre' => $modelo['nombre_artistico'] ?: $modelo['u_nombre'], // Si no tiene nombre artstico, usamos el real
        'motivo' => $motivo
    ];

    try {
        helper('email'); // Lo cargamos aqu mismo por seguridad
        enviar_notificacion($modelo['email'], 'Problema con tu verificacion - Calientitas', 'ficha_rechazada', $emailData);
    } catch (\Exception $e) {
        log_message('error', 'Error enviando correo de rechazo: ' . $e->getMessage());
    }

    return redirect()->to(base_url('admin/verificaciones'))->with('info', 'Verificacin rechazada y modelo notificada.');
}


public function resenas() {
    $resenaModel = new \App\Models\ResenaModel();
    
    $data = [
        'titulo' => 'Moderaci&oacute;n de Rese&ntilde;as',
        'usuario' => session()->get('nombre'),
        // Traemos las rese09as con los nombres de la modelo y del usuario que coment
        'resenas' => $resenaModel->select('resenas.*, modelos.nombre_artistico, usuarios.nombre as cliente')
                                    ->join('modelos', 'modelos.id = resenas.modelo_id')
                                    ->join('usuarios', 'usuarios.id = resenas.usuario_id')
                                    ->where('resenas.aprobado', 0)
                                    ->findAll()
    ];
    return view('admin/resenas/index', $data);
}

public function aprobarResena($id) {
    $resenaModel = new \App\Models\ResenaModel();
    $resenaModel->update($id, ['aprobado' => 1]);
    return redirect()->back()->with('success', 'Rese09a aprobada y visible en el sitio.');
}

public function eliminarResena($id) {
    $resenaModel = new \App\Models\ResenaModel();
    $resenaModel->delete($id);
    return redirect()->back()->with('info', 'Rese09a eliminada correctamente.');
}
public function pagos() {
    $data = [
        'titulo' => 'Gesti&oacute;n de Planes y Pagos',
        'usuario' => session()->get('nombre'),
        // Traemos todas las modelos para gestionar sus planes
        'modelos' => $this->modeloModel->orderBy('plan_expiracion', 'DESC text-shadow')->findAll()
    ];
    return view('admin/pagos/index', $data);
}

    public function activarPlan($id) {
    $membresia = $this->request->getPost('membresia');
    $dias = (int)$this->request->getPost('dias');
    $fechaExpiracion = date('Y-m-d H:i:s', strtotime("+$dias days"));

    // Actualizamos los datos en la BD
    $this->modeloModel->update($id, [
        'membresia'       => $membresia,
        'plan_expiracion' => $fechaExpiracion,
        'verificada'      => 1,
        'activo'          => 1
    ]);

    // Obtenemos los datos para el correo
    $modelo = $this->modeloModel->select('modelos.*, usuarios.email, usuarios.nombre as u_nombre')
                                ->join('usuarios', 'usuarios.id = modelos.usuario_id')
                                ->find($id);

    // Preparamos los datos para la plantilla (usamos el nombre artistico o el real como fallback)
    $emailData = [
        'nombre' => $modelo['nombre_artistico'] ?: $modelo['u_nombre'],
        'plan'   => strtoupper($membresia),
        'vence'  => date('d/m/Y', strtotime($fechaExpiracion)),
        'link'   => base_url('modelo/' . $modelo['slug'])
    ];

    // ASUNTO LIMPIO: Sin emojis para evitar errores de iconv
    $asunto = 'Tu plan ha sido activado exitosamente - Calientitas';

    try {
        helper('email');
        enviar_notificacion($modelo['email'], $asunto, 'plan_activado', $emailData);
    } catch (\Exception $e) {
        log_message('error', 'Error correo activacion plan ID ' . $id . ': ' . $e->getMessage());
    }

    return redirect()->back()->with('success', "Plan " . strtoupper($membresia) . " activado y modelo notificada.");
}


}