<?php

namespace App\Controllers;

class Api extends BaseController
{
    public function getCiudades($regionId) {
        $db = \Config\Database::connect();
        $fechaActual = date('Y-m-d H:i:s');
        
        // Capturamos un parmetro opcional: si viene 'tipo=publico', filtramos.
        // Si no viene nada (como en el registro), mostramos todo.
        $tipo = $this->request->getGet('tipo');
    
        $builder = $db->table('ciudades')
                      ->select('ciudades.id, ciudades.nombre')
                      ->where('ciudades.region_id', $regionId);
    
        if ($tipo === 'publico') {
            // Solo ciudades con modelos activos y plan vigente
            $builder->join('modelos', 'modelos.ciudad_id = ciudades.id')
                    ->where('modelos.activo', 1)
                    ->where('modelos.plan_expiracion >', $fechaActual)
                    ->groupBy('ciudades.id');
        }
    
        $ciudades = $builder->orderBy('ciudades.nombre', 'ASC')
                            ->get()
                            ->getResultArray();
    
        return $this->response->setJSON($ciudades);
    }
}