<?php

namespace App\Controllers;
use App\Models\ModeloModel;

class Home extends BaseController
{
    public function index() {
    $modeloModel = new \App\Models\ModeloModel();
    $db = \Config\Database::connect();
    $fechaActual = date('Y-m-d H:i:s');

    // 1. CAPTURA DE FILTROS
    $filtroOnline    = $this->request->getGet('online');
    $filtroHistorias = $this->request->getGet('con_historias');
    $filtroOferta    = $this->request->getGet('oferta');
    $filtroCiudad    = $this->request->getGet('ciudad');
    $filtroRegion    = $this->request->getGet('region');
    $filtroCategoria = $this->request->getGet('categoria'); 

    // --- 2. MOMENTOS EN VIVO (Historias para el carrusel del Home) ---
    $data['modelosConHistorias'] = $modeloModel->select('modelos.nombre_artistico, modelos.foto_principal, modelos.slug')
        ->join('modelo_historias', 'modelo_historias.modelo_id = modelos.id')
        ->where('modelo_historias.expira_at >', $fechaActual)
        ->where('modelos.activo', 1)
        ->groupBy('modelos.id')
        ->orderBy('modelo_historias.creado_at', 'DESC') // <-- Cambiado de created_at a creado_at
        ->findAll();

    // 3. FILTROS INTELIGENTES PARA EL BUSCADOR (Solo donde hay modelos)
    // Regiones que tienen modelos activos (Haciendo puente por ciudades)
    $data['regiones'] = $db->table('regiones')
        ->select('regiones.id, regiones.nombre')
        ->join('ciudades', 'ciudades.region_id = regiones.id') // Unimos regiones con ciudades
        ->join('modelos', 'modelos.ciudad_id = ciudades.id')    // Unimos ciudades con modelos
        ->where('modelos.activo', 1)
        ->where('modelos.plan_expiracion >', $fechaActual)
        ->groupBy('regiones.id')
        ->orderBy('regiones.nombre', 'ASC')
        ->get()->getResultArray();

    // Si hay una región seleccionada, filtramos las comunas que SOLO tienen modelos
    $data['comunas'] = [];
    if ($filtroRegion) {
        $data['comunas'] = $db->table('ciudades')
            ->select('ciudades.id, ciudades.nombre')
            ->join('modelos', 'modelos.ciudad_id = ciudades.id')
            ->where('ciudades.region_id', $filtroRegion)
            ->where('modelos.activo', 1)
            ->groupBy('ciudades.id')
            ->orderBy('ciudades.nombre', 'ASC')
            ->get()->getResultArray();
    }

    // 4. CONSTRUCCIÓN DE LA CONSULTA PRINCIPAL (Grilla de modelos)
    $sqlHistorias = "(SELECT COUNT(id) FROM modelo_historias 
                      WHERE modelo_id = modelos.id 
                      AND expira_at > '$fechaActual') as total_historias";

    $builder = $modeloModel->select('modelos.*, ciudades.nombre as ciudad_nombre')
                           ->select($sqlHistorias)
                           ->join('ciudades', 'ciudades.id = modelos.ciudad_id', 'left')
                           ->where('modelos.activo', 1)
                           ->where('modelos.verificada', 1)
                           ->where('modelos.foto_principal !=', '')
                           ->where('modelos.plan_expiracion >', $fechaActual);

    // Aplicación de filtros dinámicos
    if ($filtroCategoria) $builder->where('modelos.categoria', $filtroCategoria);
    if ($filtroOnline == '1') $builder->where('modelos.disponible_ahora', 1);
    if ($filtroOferta == '1') $builder->where('modelos.precio_oferta >', 0);
    if ($filtroRegion) $builder->where('ciudades.region_id', $filtroRegion);
    if ($filtroCiudad) $builder->where('modelos.ciudad_id', $filtroCiudad);
    if ($filtroHistorias == '1') $builder->having('total_historias >', 0);

    // 5. ORDEN DE PRIORIDAD (Híbrido: Plan -> Disponibilidad -> Actividad reciente)
    $modelos = $builder->orderBy('FIELD(modelos.membresia, "vip", "premium", "normal")') 
                       ->orderBy('modelos.disponible_ahora', 'DESC')
                       ->orderBy('modelos.updated_at', 'DESC') // Prioriza las que actualizaron perfil
                       ->findAll();

    // 6. CARGA DE DATOS PARA LA VISTA
    $data['modelos'] = $modelos;
    $data['filtros'] = [
        'categoria' => $filtroCategoria,
        'region'    => $filtroRegion,
        'ciudad'    => $filtroCiudad,
        'online'    => $filtroOnline,
        'oferta'    => $filtroOferta,
        'historias' => $filtroHistorias
    ];

    return view('public/home', $data);  
}
    
   public function perfil($slug) {
    $modeloModel = new \App\Models\ModeloModel();
    $multimediaModel = new \App\Models\MultimediaModel();
    $resenaModel = new \App\Models\ResenaModel();
    $db = \Config\Database::connect();
    
    helper(['tiempo', 'url']);

    // 1. Buscamos la modelo con su ciudad
    $modelo = $modeloModel->select('modelos.*, ciudades.nombre as ciudad_nombre')
                          ->join('ciudades', 'ciudades.id = modelos.ciudad_id', 'left')
                          ->where('slug', $slug)
                          ->first();

    if (!$modelo) {
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("La modelo no existe.");
    }

    // --- NUEVO: LÓGICA PARA MODELOS RELACIONADAS ---
    // Buscamos modelos de la misma ciudad y categoría, excluyendo a la actual
    // 1. Intentamos buscar en la misma CIUDAD
$relacionadas = $modeloModel->select('modelos.*, ciudades.nombre as ciudad_nombre')
    ->join('ciudades', 'ciudades.id = modelos.ciudad_id', 'left')
    ->where('modelos.ciudad_id', $modelo['ciudad_id'])
    ->where('modelos.categoria', $modelo['categoria'])
    ->where('modelos.id !=', $modelo['id'])
    ->where('modelos.activo', 1)
    ->where('modelos.verificada', 1)
    ->where('modelos.plan_expiracion >=', date('Y-m-d H:i:s'))
    ->orderBy('RAND()')
    ->limit(4)
    ->findAll();

// 2. Si no hay nadie en la ciudad, buscamos en la misma REGIÓN
if (empty($relacionadas)) {
    // Necesitamos saber la región de la modelo actual
    $regionId = $db->table('ciudades')->where('id', $modelo['ciudad_id'])->get()->getRow()->region_id ?? null;

    if ($regionId) {
        $relacionadas = $modeloModel->select('modelos.*, ciudades.nombre as ciudad_nombre')
            ->join('ciudades', 'ciudades.id = modelos.ciudad_id', 'left')
            ->where('ciudades.region_id', $regionId) // Filtro por Región
            ->where('modelos.categoria', $modelo['categoria'])
            ->where('modelos.id !=', $modelo['id'])
            ->where('modelos.activo', 1)
            ->where('modelos.verificada', 1)
            ->where('modelos.plan_expiracion >=', date('Y-m-d H:i:s'))
            ->orderBy('RAND()')
            ->limit(4)
            ->findAll();
    }
}
    // --- FIN LÓGICA RELACIONADAS ---

    // 2. Traer multimedia y reseñas
    $galeria = $multimediaModel->where('modelo_id', $modelo['id'])->findAll();
    $resenas = $resenaModel->select('resenas.*, usuarios.nombre')
                           ->join('usuarios', 'usuarios.id = resenas.usuario_id')
                           ->where('modelo_id', $modelo['id'])
                           ->where('aprobado', 1)
                           ->orderBy('created_at', 'DESC')
                           ->findAll();

    // 3. Cálculos de reseñas
    $total_resenas = count($resenas);
    $promedio_resenas = ($total_resenas > 0) 
        ? array_sum(array_column($resenas, 'puntuacion')) / $total_resenas 
        : 0;

    // 4. Historias Activas (solo las que no han expirado)
    $historias = $db->table('modelo_historias')
                    ->where('modelo_id', $modelo['id'])
                    ->where('expira_at >', date('Y-m-d H:i:s'))
                    ->orderBy('creado_at', 'DESC')
                    ->get()
                    ->getResultArray();

    // 5. Registro de visita (silencioso)
    $db->table('visitas_modelos')->insert([
        'modelo_id'  => $modelo['id'],
        'ip_address' => $this->request->getIPAddress(),
        'user_agent' => $this->request->getUserAgent(),
        'fecha'      => date('Y-m-d H:i:s')
    ]);

        $data = [
        'modelo'           => $modelo,
        'galeria'          => $galeria,
        'resenas'          => $resenas,
        'total_resenas'    => $total_resenas,
        'promedio_resenas' => $promedio_resenas,
        'historias'        => $historias,
        'relacionadas'     => $relacionadas,
        // Título optimizado para SEO Local: Nombre + Categoría + Ciudad
        'titulo'           => $modelo['nombre_artistico'] . " - " . ucfirst($modelo['categoria']) . " en " . ($modelo['ciudad_nombre'] ?? 'Chile') . " | Calientitas"
    ];

    return view('public/ficha_modelo', $data);
}
    
    public function buscar() {
    $db = \Config\Database::connect();
    $modeloModel = new \App\Models\ModeloModel();

    // 1. Capturar filtros del GET
    $regionId  = $this->request->getGet('region');
    $categoria = $this->request->getGet('categoria');
    $ciudadId  = $this->request->getGet('ciudad');
    $q         = $this->request->getGet('q');
    
    $online    = $this->request->getGet('online');
    $historias = $this->request->getGet('con_historias');
    $oferta    = $this->request->getGet('oferta');

    $fechaActual = date('Y-m-d H:i:s');
    
    // Definimos la subconsulta como una cadena pura
    $sqlHistoriasCount = "(SELECT COUNT(id) FROM modelo_historias 
                          WHERE modelo_id = modelos.id 
                          AND expira_at > '$fechaActual')";

    // 2. Configuración Base de la Consulta
    $builder = $modeloModel->select('modelos.*, ciudades.nombre as ciudad_nombre')
                           ->select($sqlHistoriasCount . " as total_historias", false)
                           ->join('ciudades', 'ciudades.id = modelos.ciudad_id', 'left')
                           ->where('modelos.activo', 1)
                           ->where('modelos.verificada', 1)
                           // --- EL CANDADO QUE FALTABA ---
                           ->where('modelos.plan_expiracion >=', $fechaActual) 
                           // ------------------------------
                           ->where('modelos.foto_principal !=', '')
                           ->where('modelos.foto_principal IS NOT NULL');

    // 3. Aplicar Lógica de Filtrado Dinámico (El resto del código sigue igual...)
    
    // Filtro por Región/Ciudad
    if (!empty($regionId) && empty($ciudadId)) {
        $builder->where('ciudades.region_id', $regionId);
    }
    if (!empty($ciudadId)) {
        $builder->where('modelos.ciudad_id', $ciudadId);
    }

    // Filtro por Categoría
    if (!empty($categoria)) {
        if ($categoria === 'vip') {
            $builder->where('verificada', 1);
        } else {
            $builder->where('categoria', $categoria);
        }
    }

    if ($online == '1') {
        $builder->where('modelos.disponible_ahora', 1);
    }

    if ($oferta == '1') {
        $builder->where('modelos.precio_oferta >', 0)
                ->where('modelos.precio_oferta IS NOT NULL');
    }

    if ($historias == '1') {
        $builder->where($sqlHistoriasCount . " > 0", null, false);
    }

    if (!empty($q)) {
        $builder->groupStart()
                ->like('nombre_artistico', $q)
                ->orLike('servicios_incluidos', $q)
                ->orLike('servicios_adicionales', $q)
                ->orLike('descripcion', $q)
                ->groupEnd();
    }

    // 4. Ejecución
    
    // --- NUEVO: FILTRO INTELIGENTE PARA EL SELECT DE REGIONES ---
    $regionesActivas = $db->table('regiones')
        ->select('regiones.id, regiones.nombre')
        ->join('ciudades', 'ciudades.region_id = regiones.id')
        ->join('modelos', 'modelos.ciudad_id = ciudades.id')
        ->where('modelos.activo', 1)
        ->where('modelos.plan_expiracion >=', $fechaActual)
        ->groupBy('regiones.id')
        ->orderBy('regiones.nombre', 'ASC')
        ->get()
        ->getResultArray();

    $data = [
        'titulo'   => 'Resultados de Búsqueda - Calientitas',
        'modelos'  => $builder->orderBy('verificada', 'DESC')
                              ->orderBy('id', 'DESC')
                              ->findAll(),
        'regiones' => $regionesActivas, // Ahora solo trae regiones con modelos
        'filtros'  => [ // Importante para que el JS sepa qué región/ciudad precargar
            'region' => $regionId,
            'ciudad' => $ciudadId
        ]
    ];

    return view('public/buscar', $data);
}
    
    public function registrarClic()
    {
        if ($this->request->isAJAX()) {
            try {
                $db = \Config\Database::connect();
                
                // Recibimos los datos del fetch
                $modelo_id = $this->request->getVar('modelo_id');
                $tipo      = $this->request->getVar('tipo');
    
                if ($modelo_id && $tipo) {
                    // INSERTAR - Nombres de columnas según tu tabla: id, modelo_id, tipo_boton, fecha
                    $db->table('clics_contacto')->insert([
                        'modelo_id'  => (int)$modelo_id,
                        'tipo_boton' => $tipo, // 'whatsapp' o 'llamada'
                        'fecha'      => date('Y-m-d H:i:s')
                    ]);
    
                    return $this->response->setJSON(['success' => true]);
                }
                
                return $this->response->setJSON(['success' => false, 'message' => 'Datos incompletos'], 400);
    
            } catch (\Exception $e) {
                return $this->response->setJSON(['success' => false, 'message' => $e->getMessage()], 500);
            }
        }
        return $this->response->setStatusCode(403);
    }
}