<?php

namespace App\Controllers;

use App\Models\UsuarioModel;
use App\Models\ModeloModel; // Importante para la vista de favoritas

class UsuarioController extends BaseController
{
    protected $usuarioModel;

    public function __construct() {
        $this->usuarioModel = new UsuarioModel();
    }

    public function index() {
        $userId = session()->get('user_id');
        $data = [
            'titulo'  => 'Mi Perfil - Calientitas',
            'usuario' => session()->get('nombre'),
            'rol'     => session()->get('rol'),
            'user'    => $this->usuarioModel->find($userId)
        ];
        return view('usuario/panel', $data);
    }

    // --- NUEVO: SISTEMA DE FAVORITOS (AJAX) ---
    public function toggleFavorito($modeloId) {
        if (!session()->get('isLoggedIn')) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Login requerido']);
        }

        $db = \Config\Database::connect();
        $userId = session()->get('user_id');

        // Verificar si ya existe en favoritos
        $builder = $db->table('favoritos');
        $existe = $builder->where(['usuario_id' => $userId, 'modelo_id' => $modeloId])->get()->getRow();

        if ($existe) {
            $builder->where('id', $existe->id)->delete();
            return $this->response->setJSON(['status' => 'removed']);
        } else {
            $builder->insert([
                'usuario_id' => $userId,
                'modelo_id'  => $modeloId
            ]);
            return $this->response->setJSON(['status' => 'added']);
        }
    }

    // --- NUEVO: VISTA DE MIS FAVORITAS ---
    public function favoritas() {
        $userId = session()->get('user_id');
        $db = \Config\Database::connect();

        // Traemos las modelos que el usuario marc como favoritas
        $modelos = $db->table('favoritos')
            ->select('modelos.*, ciudades.nombre as ciudad_nombre')
            ->join('modelos', 'modelos.id = favoritos.modelo_id')
            ->join('ciudades', 'ciudades.id = modelos.ciudad_id', 'left')
            ->where('favoritos.usuario_id', $userId)
            ->where('modelos.activo', 1) // Solo mostrar si siguen activas
            ->get()->getResultArray();

        $data = [
            'titulo'  => 'Mis Favoritas - Calientitas',
            'usuario' => session()->get('nombre'),
            'rol'     => session()->get('rol'),
            'modelos' => $modelos
        ];

        return view('usuario/favoritas', $data);
    }

    public function actualizar() {
        $userId = session()->get('user_id');
        $data = [
            'nombre' => $this->request->getPost('nombre'),
            'email'  => $this->request->getPost('email'),
        ];

        $pass = $this->request->getPost('password');
        if (!empty($pass)) {
            $data['password'] = password_hash($pass, PASSWORD_DEFAULT);
        }

        $this->usuarioModel->update($userId, $data);
        return redirect()->back()->with('success', 'Perfil actualizado con xito.');
    }

    public function guardarResena() {
        if (session()->get('rol') !== 'usuario') {
            return redirect()->back()->with('error', 'Solo los usuarios pueden dejar rese09as.');
        }

        $resenaModel = new \App\Models\ResenaModel();
        $data = [
            'modelo_id'  => $this->request->getPost('modelo_id'),
            'usuario_id' => session()->get('user_id'),
            'puntuacion' => $this->request->getPost('puntuacion'),
            'comentario' => $this->request->getPost('comentario'),
            'aprobado'   => 0 
        ];

        try {
            $resenaModel->insert($data);
            return redirect()->back()->with('success', '03Gracias! Tu rese09a ha sido enviada y est pendiente de moderacin.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Ocurri un error: ' . $e->getMessage());
        }
    }
}