<?php
namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateModelosTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'nombre' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
            ],
            'edad' => [
                'type'       => 'TINYINT',
                'constraint' => '3',
                'null'       => true,
            ],
            'comuna' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
            ],
            'descripcion' => [
                'type'       => 'TEXT',
                'null'       => true,
            ],
            'precio_hora' => [
                'type'       => 'INT',
                'constraint' => '11',
                'null'       => true,
            ],
            'servicios' => [
                'type' => 'JSON',
            ],
            'verificada' => [
                'type'    => 'BOOLEAN',
                'default' => false,
            ],
            'vip' => [
                'type'    => 'BOOLEAN',
                'default' => false,
            ],
            'disponible' => [
                'type'    => 'BOOLEAN',
                'default' => true,
            ],
            'foto_principal' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('modelos');
    }

    public function down()
    {
        $this->forge->dropTable('modelos');
    }
}
