<?php

namespace App\Models;

use CodeIgniter\Model;

class ModeloModel extends Model
{
    protected $table = 'modelos';
    protected $primaryKey = 'id';
    protected $allowedFields = [
        'usuario_id',
        'nombre_artistico',
        'categoria', // <--- Nuevo
        'slug',
        'descripcion',
        'edad',
        'estatura',
        'medidas',
        'telefono',
        'ubicacion',
        'precio_clp',
        'precio_oferta',        // <-- NUEVO
        'foto_principal',
        'activo',
        'verificada',
        'membresia',      // <--- Nuevo
        'plan_expiracion', // <--- Nuevo
        'rut_verificacion', 
        'selfie_verificacion',
        'documento_identidad',
        'categoria',
        'ciudad_id',
        'servicios_incluidos',
        'servicios_adicionales',
        'disponible_ahora',
        'horario_tipo',         // <-- NUEVO (Full Time, Part Time, etc)
        'horario_detalle',      // <-- NUEVO (Ej: 08:00 a 20:00)
        'lugar_atencion',       // <-- NUEVO (Depto, Hotel, etc)
        'estacionamiento',      // <-- NUEVO (0 o 1)
        'medios_pago',          // <-- NUEVO (Efectivo, Transfe)
        'observaciones_admin'
    ];

    protected $useTimestamps = true;

    // Generar slug automático antes de insertar y actualizar
    protected $beforeInsert = ['generateSlug'];
    protected $beforeUpdate = ['generateSlug']; 

    protected function generateSlug(array $data)
    {
        // Solo generamos el slug si el nombre artístico viene en los datos
        if (isset($data['data']['nombre_artistico'])) {
            $data['data']['slug'] = url_title($data['data']['nombre_artistico'], '-', true);
        }
        return $data;
    }
}