<?php

namespace App\Models;

use CodeIgniter\Model;

class UsuarioModel extends Model
{
    protected $table = 'usuarios';
    protected $primaryKey = 'id';
    // Agregamos 'telefono' que mencionaste que existe en tu tabla
    protected $allowedFields = ['email', 'password', 'rol', 'nombre', 'telefono', 'activo'];
    protected $useTimestamps = true;
    protected $createdField = 'created_at';
    protected $updatedField  = ''; // Si no tienes updated_at, mejor dejarlo vacío

    public function login($email, $password)
    {
        // 1. Buscamos el usuario solo por email primero
        $user = $this->where('email', $email)->first();

        // 2. Si el usuario existe
        if ($user) {
            
            // Debug para cPanel: Nos aseguramos que 'activo' se trate como número
            if ((int)$user['activo'] !== 1) {
                return false; 
            }

            // 3. Verificamos la contraseña con el hash de la base de datos
            if (password_verify($password, $user['password'])) {
                // Quitamos la contraseña del array por seguridad antes de devolverlo
                unset($user['password']);
                return $user;
            }
        }

        return false;
    }
}