<?= $this->extend('layouts/admin_layout') ?>

<?= $this->section('content') ?>

<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.tailwind.min.css">
<style>
    .dataTables_wrapper { width: 100% !important; }
    .dataTables_filter input, .dataTables_length select {
        background-color: #1a1415 !important;
        border: 1px solid #39282c !important;
        color: white !important;
        border-radius: 8px !important;
        padding: 5px 10px !important;
    }
    .btn-bolt-fix {
        display: flex;
        align-items: center;
        justify-content: center;
        line-height: 0;
        font-size: 0;
    }
    .btn-bolt-fix span { font-size: 18px !important; }
    .avatar-container { position: relative; width: 56px; height: 56px; }
    .badge-verified {
        position: absolute;
        top: -4px;
        right: -4px;
        background-color: #3b82f6;
        color: white;
        border-radius: 9999px;
        width: 18px;
        height: 18px;
        display: flex;
        align-items: center;
        justify-content: center;
        border: 2px solid #181113;
        z-index: 10;
    }
</style>

<div class="p-8 space-y-8">
    <div class="flex flex-col md:flex-row md:items-center justify-between gap-4 bg-surface-dark p-8 rounded-3xl border border-border-dark shadow-2xl">
        <div>
            <h1 class="text-3xl font-black text-white uppercase tracking-tighter italic">Gestión de Modelos</h1>
            <p class="text-gray-500 text-sm italic">Administración central de cuentas y membresías.</p>
        </div>
        <div class="flex items-center gap-6">
            <div class="text-right">
                <p class="text-gray-500 text-[10px] font-bold uppercase tracking-widest">Total Registros</p>
                <p class="text-white text-2xl font-black italic"><?= count($modelos) ?> <span class="text-primary text-sm uppercase">Perfiles</span></p>
            </div>
            <button class="bg-primary hover:bg-primary/80 text-white px-5 py-3 rounded-2xl font-black text-xs uppercase transition-all flex items-center gap-2 shadow-lg shadow-primary/30">
                <span class="material-symbols-outlined text-sm">person_add</span> Nueva Modelo
            </button>
        </div>
    </div>

    <div class="bg-surface-dark rounded-3xl border border-border-dark shadow-2xl overflow-hidden p-8">
        <table id="tablaModelos" class="w-full display border-none">
            <thead class="bg-black/20 text-gray-500 uppercase text-[10px] font-black tracking-widest">
                <tr>
                    <th class="px-6 py-5 text-left">Modelo</th>
                    <th class="px-6 py-5 text-left">Plan Actual</th>
                    <th class="px-6 py-5 text-left text-center">Verificación</th>
                    <th class="px-6 py-5 text-left text-center">Configurar Plan</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-border-dark/50">
                <?php foreach($modelos as $m): ?>
                <tr class="hover:bg-white/[0.02] transition-colors group">
                    <td class="px-6 py-5">
                        <div class="flex items-center gap-4">
                            <div class="avatar-container">
                                <img src="<?= base_url('uploads/modelos/'.$m['foto_principal']) ?>" class="w-full h-full rounded-2xl object-cover border border-border-dark shadow-lg" onerror="this.src='<?= base_url('assets/img/placeholder.jpg') ?>'">
                                <?php if($m['verificada'] == 1): ?>
                                    <div class="badge-verified" title="Perfil Verificado">
                                        <span class="material-symbols-outlined text-[10px] font-bold">check</span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div>
                                <p class="font-black text-white text-sm uppercase tracking-tight"><?= $m['nombre_artistico'] ?: 'SIN NOMBRE' ?></p>
                                <p class="text-[10px] text-gray-500 font-medium"><?= $m['email'] ?></p>
                            </div>
                        </div>
                    </td>

                    <td class="px-6 py-5">
                        <?php 
                            $hoy = date('Y-m-d H:i:s');
                            $esActivo = (!empty($m['plan_expiracion']) && $m['plan_expiracion'] > $hoy);
                        ?>
                        <div class="flex flex-col gap-1">
                            <?php if($esActivo): ?>
                                <span class="w-fit px-2.5 py-0.5 rounded-full bg-emerald-500/10 text-emerald-500 text-[9px] font-black uppercase border border-emerald-500/20 italic tracking-widest">
                                    PLAN <?= strtoupper($m['membresia']) ?>
                                </span>
                                <p class="text-[10px] text-gray-400 font-bold ml-1 italic"><?= date('d M, Y', strtotime($m['plan_expiracion'])) ?></p>
                            <?php else: ?>
                                <span class="w-fit px-2.5 py-0.5 rounded-full bg-red-500/10 text-red-500 text-[9px] font-black uppercase border border-red-500/20 italic tracking-widest">
                                    EXPIRADO
                                </span>
                            <?php endif; ?>
                        </div>
                    </td>

                    <td class="px-6 py-5 text-center">
                        <?php if($m['verificada'] == 1): ?>
                            <div class="text-blue-400 bg-blue-400/10 p-2 rounded-xl inline-flex border border-blue-400/20 shadow-inner" title="Verificado Correctamente">
                                <span class="material-symbols-outlined text-[20px] font-variation-settings: 'FILL' 1">verified</span>
                            </div>
                        <?php elseif(!empty($m['documento_identidad'])): ?>
                            <a href="<?= base_url('admin/verificaciones') ?>" class="relative text-yellow-500 bg-yellow-500/10 p-2 rounded-xl inline-flex border border-yellow-500/20 hover:scale-110 transition-transform shadow-lg" title="Documentos pendientes">
                                <span class="material-symbols-outlined text-[20px]">id_card</span>
                                <span class="absolute -top-1 -right-1 flex h-3 w-3">
                                    <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-yellow-400 opacity-75"></span>
                                    <span class="relative inline-flex rounded-full h-3 w-3 bg-yellow-500 border border-black"></span>
                                </span>
                            </a>
                        <?php else: ?>
                            <div class="text-gray-600 bg-gray-600/10 p-2 rounded-xl inline-flex border border-gray-600/20 opacity-40" title="Sin documentos">
                                <span class="material-symbols-outlined text-[20px]">no_photography</span>
                            </div>
                        <?php endif; ?>
                    </td>

                    <td class="px-6 py-5 text-center">
                        <form action="<?= base_url('admin/activar-plan/'.$m['id']) ?>" method="POST" class="inline-flex items-center gap-2 bg-black/40 p-1.5 pl-4 rounded-2xl border border-border-dark group-hover:border-primary/30 transition-colors">
                            <div class="flex gap-3">
                                <select name="membresia" class="bg-transparent border-none text-[10px] font-black text-gray-400 focus:ring-0 cursor-pointer uppercase p-0">
                                    <option value="normal" class="bg-card-dark" <?= ($m['membresia'] ?? '') == 'normal' ? 'selected' : '' ?>>Normal</option>
                                    <option value="premium" class="bg-card-dark" <?= ($m['membresia'] ?? '') == 'premium' ? 'selected' : '' ?>>Premium</option>
                                    <option value="vip" class="bg-card-dark" <?= ($m['membresia'] ?? '') == 'vip' ? 'selected' : '' ?>>VIP Gold</option>
                                </select>
                                <select name="dias" class="bg-transparent border-none text-[10px] font-black text-gray-400 focus:ring-0 cursor-pointer uppercase p-0">
                                    <option value="7" class="bg-card-dark">7 Días</option>
                                    <option value="30" class="bg-card-dark" selected>30 Días</option>
                                    <option value="365" class="bg-card-dark">1 Año</option>
                                </select>
                            </div>
                            <button type="submit" class="bg-white hover:bg-primary hover:text-white text-black size-8 rounded-xl transition-all btn-bolt-fix shadow-lg group-hover:scale-110">
                                <span class="material-symbols-outlined">bolt</span>
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.0.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.tailwind.min.js"></script>

<script>
    $(document).ready(function() {
        $('#tablaModelos').DataTable({
            "language": { "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json" },
            "pageLength": 10,
            "dom": '<"flex flex-col md:flex-row justify-between items-center mb-6 gap-4"lf>rt<"flex justify-between items-center mt-6"ip>',
            "order": [[1, "desc"]],
            "responsive": true
        });
    });
</script>

<?= $this->endSection() ?>