<?= $this->extend('layouts/admin_layout') ?>

<?= $this->section('content') ?>
<div class="p-6 lg:p-10">
    <div class="flex items-center gap-3 mb-8">
        <span class="material-symbols-outlined text-primary text-3xl">rate_review</span>
        <h1 class="text-3xl font-black uppercase italic tracking-tighter text-white">Moderación de Reseñas</h1>
    </div>

    <?php if (empty($resenas)): ?>
        <div class="bg-surface-dark border border-dashed border-white/10 p-20 rounded-3xl text-center">
            <span class="material-symbols-outlined text-gray-700 text-6xl mb-4">task_alt</span>
            <p class="text-gray-500 font-bold uppercase tracking-widest text-sm">No hay reseñas pendientes</p>
        </div>
    <?php else: ?>
        <div class="grid grid-cols-1 gap-4">
            <?php foreach ($resenas as $r): ?>
                <div class="bg-surface-dark border border-white/5 p-6 rounded-2xl flex flex-col md:flex-row justify-between items-center gap-6 group hover:border-primary/30 transition-all">
                    
                    <div class="flex-1">
                        <div class="flex items-center gap-3 mb-2">
                            <span class="px-2 py-1 bg-primary/10 text-primary text-[10px] font-black uppercase rounded-md tracking-tighter">
                                <?= $r['cliente'] ?>
                            </span>
                            <span class="text-gray-600 text-xs italic">escribió sobre</span>
                            <span class="text-white font-black text-xs uppercase underline decoration-primary/30">
                                <?= $r['nombre_artistico'] ?>
                            </span>
                        </div>

                        <div class="flex text-gold mb-3">
                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                <span class="material-symbols-outlined text-sm <?= $i <= $r['puntuacion'] ? 'filled' : 'opacity-20' ?>" 
                                      style="font-variation-settings: 'FILL' <?= $i <= $r['puntuacion'] ? '1' : '0' ?>;">star</span>
                            <?php endfor; ?>
                        </div>

                        <p class="text-gray-400 text-sm leading-relaxed max-w-2xl italic">"<?= $r['comentario'] ?>"</p>
                        <p class="text-[9px] text-gray-600 mt-4 font-bold uppercase tracking-widest">
                            Enviada el <?= date('d/m/Y H:i', strtotime($r['created_at'])) ?>
                        </p>
                    </div>

                    <div class="flex gap-2 w-full md:w-auto">
                        <a href="<?= base_url('admin/aprobar-resena/' . $r['id']) ?>" 
                           class="flex-1 md:flex-none bg-emerald-500 hover:bg-emerald-600 text-white px-6 py-3 rounded-xl text-[10px] font-black uppercase tracking-widest transition-all text-center">
                            Aprobar
                        </a>
                        <a href="<?= base_url('admin/eliminar-resena/' . $r['id']) ?>" 
                           onclick="return confirm('¿Seguro que quieres eliminar este comentario?')"
                           class="flex-1 md:flex-none bg-white/5 hover:bg-red-500/20 text-red-500 px-6 py-3 rounded-xl text-[10px] font-black uppercase tracking-widest transition-all text-center">
                            Eliminar
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>
<?= $this->endSection() ?>