<?= $this->extend('layouts/admin_layout') ?>

<?= $this->section('content') ?>

<div class="p-8 space-y-8">
    <div class="flex flex-col md:flex-row md:items-center justify-between gap-4 bg-surface-dark p-8 rounded-3xl border border-border-dark shadow-2xl">
        <div>
            <h1 class="text-3xl font-black text-white uppercase tracking-tighter italic flex items-center gap-3">
                <span class="material-symbols-outlined text-gold text-4xl font-variation-settings: 'FILL' 1">verified_user</span>
                Centro de Verificaciones
            </h1>
            <p class="text-gray-500 text-sm italic">Valida la identidad de las modelos para permitir su publicaci&oacute;n.</p>
        </div>
        <div class="bg-gold/10 px-6 py-3 rounded-2xl border border-gold/20 text-right">
            <p class="text-gray-500 text-[10px] font-black uppercase tracking-widest leading-none mb-1">Por revisar</p>
            <p class="text-gold text-2xl font-black italic"><?= count($modelos ?? []) ?> <span class="text-xs uppercase">Pendientes</span></p>
        </div>
    </div>

    <?php if(empty($modelos ?? [])): ?>
        <div class="bg-surface-dark/50 py-24 text-center rounded-3xl border border-dashed border-border-dark">
            <div class="size-20 bg-emerald-500/10 text-emerald-500 rounded-full flex items-center justify-center mx-auto mb-4">
                <span class="material-symbols-outlined text-4xl font-variation-settings: 'FILL' 1">done_all</span>
            </div>
            <h3 class="text-white font-bold text-xl uppercase tracking-tight">&#161;Todo al d&iacute;a&#33;</h3>
            <p class="text-gray-500 mt-2 text-sm italic">No hay solicitudes de verificaci&oacute;n pendientes por ahora.</p>
        </div>
    <?php else: ?>
        <div class="grid grid-cols-1 xl:grid-cols-2 gap-8">
            <?php foreach($modelos as $m): ?>
            <div class="bg-surface-dark p-8 rounded-3xl border border-border-dark space-y-6 shadow-2xl hover:border-gold/30 transition-all group">
                
                <div class="flex items-center justify-between border-b border-white/5 pb-6">
                    <div class="flex items-center gap-4">
                        <img src="<?= base_url('uploads/modelos/'.$m['foto_principal']) ?>" 
                             class="size-16 rounded-2xl object-cover border border-border-dark shadow-xl group-hover:scale-105 transition-transform"
                             onerror="this.src='<?= base_url('assets/img/placeholder.jpg') ?>'">
                        <div>
                            <h3 class="text-white text-xl font-black uppercase tracking-tighter italic"><?= $m['nombre_artistico'] ?></h3>
                            <div class="flex items-center gap-2 mt-1">
                                <span class="text-[10px] font-black text-gold bg-gold/10 px-2 py-0.5 rounded-md uppercase tracking-widest border border-gold/20">RUT: <?= $m['rut_verificacion'] ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                         <p class="text-[9px] text-gray-500 font-bold uppercase tracking-widest">Registrada el</p>
                         <p class="text-xs text-white font-bold"><?= date('d M, Y', strtotime($m['created_at'] ?? 'now')) ?></p>
                    </div>
                </div>

                <div class="grid grid-cols-2 gap-6">
                    <div class="space-y-3">
                        <p class="text-[10px] font-black text-gray-500 uppercase tracking-widest flex items-center gap-2">
                            <span class="material-symbols-outlined text-sm">photo_camera</span> Selfie con ID
                        </p>
                        <a href="<?= base_url('uploads/modelos/documentos/'.$m['selfie_verificacion']) ?>" target="_blank" class="block relative group/img">
                            <img src="<?= base_url('uploads/modelos/documentos/'.$m['selfie_verificacion']) ?>" 
                                 class="rounded-2xl border border-border-dark hover:border-gold/50 transition-all cursor-zoom-in aspect-[4/3] object-cover bg-black">
                            <div class="absolute inset-0 bg-gold/20 opacity-0 group-hover/img:opacity-100 transition-opacity flex items-center justify-center rounded-2xl">
                                <span class="material-symbols-outlined text-white text-3xl">zoom_in</span>
                            </div>
                        </a>
                    </div>
                    <div class="space-y-3">
                        <p class="text-[10px] font-black text-gray-500 uppercase tracking-widest flex items-center gap-2">
                            <span class="material-symbols-outlined text-sm">badge</span> Documento Frontal
                        </p>
                        <a href="<?= base_url('uploads/modelos/documentos/'.$m['documento_identidad']) ?>" target="_blank" class="block relative group/img">
                            <img src="<?= base_url('uploads/modelos/documentos/'.$m['documento_identidad']) ?>" 
                                 class="rounded-2xl border border-border-dark hover:border-gold/50 transition-all cursor-zoom-in aspect-[4/3] object-cover bg-black">
                            <div class="absolute inset-0 bg-gold/20 opacity-0 group-hover/img:opacity-100 transition-opacity flex items-center justify-center rounded-2xl">
                                <span class="material-symbols-outlined text-white text-3xl">zoom_in</span>
                            </div>
                        </a>
                    </div>
                </div>

                <div class="flex flex-col gap-4 pt-6 border-t border-white/5">
                    
                    <a href="<?= base_url('admin/validar-modelo/'.$m['id']) ?>" 
                       onclick="return confirm('&#191;Confirmas que la identidad de la modelo es real&#63;')"
                       class="w-full bg-gold hover:bg-yellow-400 text-black py-4 rounded-2xl font-black text-center text-xs uppercase tracking-widest transition-all shadow-lg shadow-gold/10 flex items-center justify-center gap-2">
                        <span class="material-symbols-outlined font-bold">check_circle</span>
                        Aprobar y Activar Perfil
                    </a>

                    <div class="bg-black/20 p-4 rounded-2xl border border-border-dark">
                        <form action="<?= base_url('admin/rechazar-modelo/'.$m['id']) ?>" method="POST" class="space-y-3">
                            <label class="text-[10px] font-black text-primary uppercase tracking-widest ml-1">Rechazar por motivo:</label>
                            <select name="motivo_rechazo" required class="w-full bg-black/40 border border-primary/20 text-gray-300 text-xs rounded-xl px-4 py-3 outline-none focus:border-primary transition-all appearance-none cursor-pointer">
                                <option value="" disabled selected>-- SELECCIONAR MOTIVO --</option>
                                <option value="Las fotos se ven borrosas o movidas. Por favor intenta con mejor iluminaci&oacute;n.">Fotos borrosas / ilegibles</option>
                                <option value="El rostro en la selfie no coincide con la foto del documento de identidad.">Identidad no coincide</option>
                                <option value="El RUT ingresado no coincide con el documento de identidad adjunto.">RUT incorrecto</option>
                                <option value="Documento de identidad vencido o no v&aacute;lido.">Documento vencido</option>
                                <option value="Falta la selfie sosteniendo el documento al lado de tu rostro.">Falta Selfie con ID</option>
                            </select>
                            <button type="submit" class="w-full border border-primary/30 text-primary py-3 rounded-xl font-black text-[10px] uppercase tracking-widest hover:bg-primary hover:text-white transition-all">
                                Rechazar y Notificar a Modelo
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

<?= $this->endSection() ?>