<!DOCTYPE html>
<html class="dark" lang="es">
<head>
    <meta charset="utf-8"/>
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <title>Login - Calientitas</title>
    <script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;700;800&family=Noto+Sans:wght@400;500;700&display=swap" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&display=swap" rel="stylesheet"/>
    <script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#ee2b5b",
                        "background-light": "#f8f6f6",
                        "background-dark": "#221015",
                        "surface-dark": "#271c1e",
                        "border-dark": "#543b41",
                        "gold-accent": "#D4AF37",
                        "success-bg": "#064e3b",
                        "success-text": "#34d399",
                    },
                    fontFamily: {
                        "display": ["Plus Jakarta Sans", "Noto Sans", "sans-serif"],
                        "body": ["Noto Sans", "sans-serif"],
                    },
                    borderRadius: {"DEFAULT": "0.25rem", "lg": "0.5rem", "xl": "0.75rem", "full": "9999px"},
                },
            },
        }
    </script>
    <style>
        .material-symbols-outlined { font-variation-settings: 'FILL' 0, 'wght' 400, 'GRAD' 0, 'opsz' 24; }
        ::-webkit-scrollbar { width: 8px; }
        ::-webkit-scrollbar-track { background: #221015; }
        ::-webkit-scrollbar-thumb { background: #543b41; border-radius: 4px; }
        ::-webkit-scrollbar-thumb:hover { background: #ee2b5b; }
        
        @keyframes slideDown {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .animate-alert { animation: slideDown 0.4s ease-out forwards; }
    </style>
</head>
<body class="font-display bg-background-light dark:bg-background-dark text-slate-900 dark:text-white antialiased min-h-screen flex flex-col">
<div class="flex min-h-screen w-full overflow-hidden">
    
    <div class="hidden lg:block lg:w-1/2 xl:w-7/12 relative bg-black">
        <div class="absolute inset-0 bg-cover bg-center opacity-80" style="background-image: url('https://images.unsplash.com/photo-1494790108377-be9c29b29330?q=80&w=1887&auto=format&fit=crop');"></div>
        <div class="absolute inset-0 bg-gradient-to-t from-background-dark via-background-dark/40 to-transparent mix-blend-multiply"></div>
        <div class="absolute inset-0 bg-gradient-to-r from-transparent to-background-dark"></div>
        <div class="absolute bottom-12 left-12 right-12 text-white z-10">
            <div class="flex items-center gap-3 mb-4">
                <span class="material-symbols-outlined text-gold-accent text-4xl font-variation-settings: 'FILL' 1">verified</span>
                <p class="text-sm font-medium tracking-widest uppercase text-gold-accent">Verificado & Exclusivo</p>
            </div>
            <h2 class="text-4xl md:text-5xl font-bold leading-tight max-w-lg italic">Únete a la comunidad más selecta de Chile.</h2>
        </div>
    </div>

    <div class="w-full lg:w-1/2 xl:w-5/12 flex flex-col bg-background-light dark:bg-background-dark relative overflow-y-auto">
        <header class="flex items-center justify-between px-6 py-6 lg:px-12 lg:pt-8">
            <div class="flex items-center gap-2 text-slate-900 dark:text-white">
                <div class="size-8 text-primary">
                    <span class="material-symbols-outlined text-[32px]">local_fire_department</span>
                </div>
                <span class="text-xl font-black tracking-tighter uppercase italic">Calientitas</span>
            </div>
            
            <a class="flex items-center gap-2 text-[10px] font-black uppercase tracking-widest text-primary hover:text-white transition-all bg-primary/5 px-4 py-2 rounded-full border border-primary/20" href="<?= base_url('/') ?>">
                <span class="material-symbols-outlined text-sm">arrow_back</span>
                <span class="hidden sm:inline">Volver al inicio</span>
                <span class="sm:hidden">Inicio</span>
            </a>
        </header>

        <div class="flex-1 flex items-center justify-center p-6 sm:px-12 xl:px-24">
            <div class="w-full max-w-[440px] flex flex-col gap-6">
                
                <div class="text-center sm:text-left">
                    <h1 class="text-slate-900 dark:text-white tracking-tight text-3xl font-black leading-tight mb-2 uppercase italic">Bienvenido de nuevo</h1>
                    <p class="text-slate-500 dark:text-gray-400 text-sm font-medium">Gestiona tu perfil y conecta con clientes.</p>
                </div>

                <?php if (session()->getFlashdata('success')): ?>
                    <div id="alert-s" class="animate-alert flex items-center p-4 text-emerald-400 border border-emerald-500/30 rounded-2xl bg-emerald-500/10" role="alert">
                        <span class="material-symbols-outlined text-xl">check_circle</span>
                        <div class="ms-3 text-xs font-bold uppercase tracking-wide">
                            <?= session()->getFlashdata('success') ?>
                        </div>
                        <button type="button" onclick="this.parentElement.style.display='none'" class="ms-auto text-emerald-400 hover:bg-emerald-500/20 rounded-lg p-1 inline-flex h-8 w-8 items-center justify-center">
                            <span class="material-symbols-outlined text-lg">close</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if (session()->getFlashdata('error')): ?>
                    <div id="alert-e" class="animate-alert flex items-center p-4 text-primary border border-primary/30 rounded-2xl bg-primary/10" role="alert">
                        <span class="material-symbols-outlined text-xl">error</span>
                        <div class="ms-3 text-xs font-bold uppercase tracking-wide">
                            <?= session()->getFlashdata('error') ?>
                        </div>
                        <button type="button" onclick="this.parentElement.style.display='none'" class="ms-auto text-primary hover:bg-primary/20 rounded-lg p-1 inline-flex h-8 w-8 items-center justify-center">
                            <span class="material-symbols-outlined text-lg">close</span>
                        </button>
                    </div>
                <?php endif; ?>

                <form action="<?= base_url('auth/login') ?>" method="post" class="flex flex-col gap-5">
                    <?= csrf_field() ?>
                    
                    <div class="flex flex-col gap-2">
                        <label class="text-slate-700 dark:text-gray-400 text-[10px] font-black uppercase tracking-widest ml-1" for="email">Correo o Usuario</label>
                        <div class="relative">
                            <input name="email" value="<?= old('email') ?>" class="form-input flex w-full rounded-xl text-slate-900 dark:text-white border border-gray-300 dark:border-border-dark bg-white dark:bg-surface-dark focus:border-primary focus:ring-1 focus:ring-primary h-12 px-4 placeholder:text-gray-500 text-sm font-medium transition-all" id="email" placeholder="ejemplo@modelo.cl" type="text" required/>
                            <div class="absolute right-4 top-1/2 -translate-y-1/2 text-gray-500">
                                <span class="material-symbols-outlined text-[20px]">person</span>
                            </div>
                        </div>
                    </div>

                    <div class="flex flex-col gap-2">
                        <label class="text-slate-700 dark:text-gray-400 text-[10px] font-black uppercase tracking-widest ml-1" for="password">Contraseña</label>
                        <div class="relative flex w-full items-stretch rounded-xl">
                            <input name="password" class="form-input flex w-full rounded-xl text-slate-900 dark:text-white border border-gray-300 dark:border-border-dark bg-white dark:bg-surface-dark focus:border-primary focus:ring-1 focus:ring-primary h-12 px-4 placeholder:text-gray-500 pr-12 text-sm font-medium transition-all" id="password" placeholder="••••••••" type="password" required/>
                            <button class="absolute right-0 top-0 bottom-0 px-4 text-gray-500 hover:text-primary transition-colors flex items-center justify-center" type="button" onclick="const p = document.getElementById('password'); p.type = p.type === 'password' ? 'text' : 'password';">
                                <span class="material-symbols-outlined text-[20px]">visibility</span>
                            </button>
                        </div>
                    </div>

                    <div class="flex items-center justify-between mt-1">
                        <label class="flex items-center gap-2 cursor-pointer group">
                            <input class="rounded border-gray-300 dark:border-border-dark bg-white dark:bg-surface-dark text-primary focus:ring-primary transition-colors" type="checkbox"/>
                            <span class="text-xs font-bold text-slate-600 dark:text-gray-500 group-hover:text-primary transition-colors uppercase tracking-tight">Recordarme</span>
                        </label>
                        <a class="text-xs font-bold text-primary hover:text-white transition-colors uppercase tracking-tight" href="<?= base_url('auth/recuperar') ?>">¿Olvidaste tu contraseña?</a>
                    </div>

                    <button class="mt-4 flex w-full cursor-pointer items-center justify-center rounded-xl h-14 px-4 bg-primary hover:bg-primary/90 text-white text-sm font-black tracking-widest transition-all shadow-lg shadow-primary/25 active:scale-95" type="submit">
                        <span class="truncate uppercase italic">Iniciar Sesión</span>
                    </button>
                </form>

                <div class="text-center mt-2">
                    <p class="text-slate-600 dark:text-gray-500 text-xs font-bold uppercase tracking-tight">
                        ¿Aún no tienes una cuenta? <a class="text-primary hover:text-white transition-colors ml-1 border-b border-primary/20" href="<?= base_url('registro') ?>">Regístrate gratis</a>
                    </p>
                </div>
            </div>
        </div>
        
        <footer class="px-12 py-8 text-center lg:text-left opacity-30">
            <p class="text-[9px] font-black text-gray-500 uppercase tracking-[4px]">&copy; 2026 Calientitas Chile</p>
        </footer>
    </div>
</div>
</body>
</html>