<?= $this->extend('layouts/home_layout') ?>
<?= $this->section('content') ?>
<div class="flex flex-1 items-center justify-center p-6 min-h-[80vh]">
    <div class="w-full max-w-[440px] bg-surface-dark border border-border-dark p-8 rounded-3xl shadow-2xl">
        <div class="text-center mb-8">
            <h1 class="text-2xl font-black uppercase italic">Nueva Contrase&ntilde;a</h1>
            <p class="text-gray-500 text-sm mt-2">Ingresa tu nueva clave de acceso.</p>
        </div>

        <form action="<?= base_url('auth/actualizar-password') ?>" method="POST" class="space-y-5" id="resetForm">
            <?= csrf_field() ?>
            <input type="hidden" name="token" value="<?= $token ?>">

            <div class="flex flex-col gap-2">
                <label class="text-[10px] font-black uppercase tracking-widest text-gray-400 ml-1">Nueva Contrase&ntilde;a</label>
                <div class="relative">
                    <input type="password" id="password" name="password" required minlength="6" placeholder="••••••••" 
                           class="w-full h-14 bg-background-dark border border-border-dark rounded-2xl px-5 text-sm focus:border-primary outline-none transition-all">
                </div>
            </div>

            <div class="flex flex-col gap-2">
                <label class="text-[10px] font-black uppercase tracking-widest text-gray-400 ml-1">Confirmar Contrase&ntilde;a</label>
                <input type="password" id="pass_confirm" name="pass_confirm" required placeholder="••••••••" 
                       class="w-full h-14 bg-background-dark border border-border-dark rounded-2xl px-5 text-sm focus:border-primary outline-none transition-all">
            </div>
            
            <button type="submit" class="w-full h-14 bg-primary hover:bg-primary/90 text-white font-black rounded-2xl shadow-lg shadow-primary/20 uppercase tracking-widest text-sm transition-all active:scale-95">
                Actualizar Contrase&ntilde;a
            </button>
        </form>
    </div>
</div>

<script>
    const password = document.getElementById("password");
    const confirm_password = document.getElementById("pass_confirm");

    function validatePassword(){
        if(password.value != confirm_password.value) {
            confirm_password.setCustomValidity("Las contraseñas no coinciden");
        } else {
            confirm_password.setCustomValidity('');
        }
    }
    password.onchange = validatePassword;
    confirm_password.onkeyup = validatePassword;
</script>
<?= $this->endSection() ?>