<!DOCTYPE html>

<html class="dark" lang="es"><head>
<meta charset="utf-8"/>
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<title>ModeloPlanet Mobile Home</title>
<!-- Tailwind CSS -->
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
<!-- Google Fonts -->
<link href="https://fonts.googleapis.com" rel="preconnect"/>
<link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
<link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&amp;display=swap" rel="stylesheet"/>
<!-- Material Symbols -->
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&amp;display=swap" rel="stylesheet"/>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&amp;display=swap" rel="stylesheet"/>
<!-- Theme Configuration -->
<script>
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#ee2b5b",
                        "primary-dark": "#c91d48",
                        "secondary": "#D4AF37", // Gold
                        "background-light": "#f8f6f6",
                        "background-dark": "#221015",
                        "card-dark": "#2d161c",
                        "text-muted": "#b99da4",
                    },
                    fontFamily: {
                        "display": ["Plus Jakarta Sans", "sans-serif"],
                        "body": ["Plus Jakarta Sans", "sans-serif"],
                    },
                    backgroundImage: {
                        'gradient-radial': 'radial-gradient(var(--tw-gradient-stops))',
                    }
                },
            },
        }
    </script>
<style>
        .no-scrollbar::-webkit-scrollbar {
            display: none;
        }
        .no-scrollbar {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }
        .glass-nav {
            background: rgba(34, 16, 21, 0.85);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
        }
    </style>
</head>
<body class="bg-background-light dark:bg-background-dark text-slate-900 dark:text-white font-display antialiased selection:bg-primary selection:text-white">
<div class="relative flex min-h-screen w-full flex-col overflow-x-hidden pb-24 max-w-md mx-auto border-x border-[#39282c]">
<!-- Top Navigation -->
<header class="sticky top-0 z-50 glass-nav border-b border-[#39282c] px-4 py-3 flex items-center justify-between">
<div class="flex items-center gap-3">
<div class="size-8 rounded-full bg-gradient-to-br from-primary to-purple-600 flex items-center justify-center shadow-lg shadow-primary/20">
<span class="material-symbols-outlined text-white text-[20px]">diamond</span>
</div>
<h1 class="text-xl font-bold tracking-tight text-white">Modelo<span class="text-primary">Planet</span></h1>
</div>
<div class="flex gap-2">
<button class="flex items-center justify-center size-10 rounded-full bg-[#39282c]/50 hover:bg-[#39282c] text-white transition-colors">
<span class="material-symbols-outlined">notifications</span>
</button>
</div>
</header>
<!-- Hero Slider (Banners) -->
<div class="w-full pt-6 px-4">
<div class="flex overflow-x-auto gap-4 no-scrollbar snap-x snap-mandatory pb-4">
<!-- Banner 1 -->
<div class="relative min-w-[300px] w-full h-48 rounded-2xl overflow-hidden snap-center shadow-lg group">
<div class="absolute inset-0 bg-cover bg-center transition-transform duration-700 group-hover:scale-105" data-alt="Fashion model posing in urban setting with dramatic lighting" style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuCqo4HnQ54Xrmo6cMA4wURwO0AkT20Ut8ZhO1CUxHN5Hx6mcJt7cf-vkYUba08p-6AMc2KqyAJbpAKzxiqGQKxu4H3XrdqJ-f27vHYJprP05TDRC9JE2cT00TErw21kG5iKAjvlsK5raaqLw11_3woPTBwnp6EVEVCAslDn3t8PCAlWBkN7M6XF0QLH7Sz1_kTo8ruE1X0pTaLq-WD-V6-x49FD3m-jaSLwbAKdzMe35scjKeysaGdvTU9Jk4b2NwJ3Hp_2PYTTwegl')"></div>
<div class="absolute inset-0 bg-gradient-to-t from-black/80 via-black/20 to-transparent"></div>
<div class="absolute bottom-0 left-0 p-5 w-full">
<span class="inline-block px-2 py-0.5 rounded text-[10px] font-bold bg-secondary text-black mb-2 uppercase tracking-wider">Destacado</span>
<h2 class="text-white text-2xl font-bold leading-tight mb-1">Nuevas Rostros</h2>
<p class="text-gray-200 text-sm mb-3">Descubre el talento emergente.</p>
<button class="bg-primary hover:bg-primary-dark text-white text-xs font-bold py-2 px-4 rounded-full transition-colors">
                            Ver Colección
                        </button>
</div>
</div>
<!-- Banner 2 -->
<div class="relative min-w-[300px] w-full h-48 rounded-2xl overflow-hidden snap-center shadow-lg group">
<div class="absolute inset-0 bg-cover bg-center transition-transform duration-700 group-hover:scale-105" data-alt="Portrait of a smiling model with soft natural lighting" style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuDIWIhr8Dis3d4-AY0YNkyQvKSYgOYDUUu9PP7LJJEJSi3z7pjjVD0K-OjkuOHMvXgki42_9rXPyzeXj21KxjR7wbX31zpvOLa05kohSeMP1EwKqb6AaIg7KJANsf7oGD7c98a7LTzJqBKAp4kmiEwR7AhFJKChYFQiJDzrFumeP6QmD9TmYeN2zVqioDrOBoT3U_g6Xj30DOSOIr5oMHBvTTLggMyX8cO4iaRBhzYjiyAZop-oJclhr79acarrIVc7sFiRyJURGP9_')"></div>
<div class="absolute inset-0 bg-gradient-to-t from-black/80 via-black/20 to-transparent"></div>
<div class="absolute bottom-0 left-0 p-5 w-full">
<span class="inline-block px-2 py-0.5 rounded text-[10px] font-bold bg-primary text-white mb-2 uppercase tracking-wider">Premium</span>
<h2 class="text-white text-2xl font-bold leading-tight mb-1">Top Verificadas</h2>
<p class="text-gray-200 text-sm mb-3">Seguridad y confianza garantizada.</p>
<button class="bg-white/10 backdrop-blur-md border border-white/30 hover:bg-white/20 text-white text-xs font-bold py-2 px-4 rounded-full transition-colors">
                            Explorar
                        </button>
</div>
</div>
</div>
</div>
<!-- Filters Section -->
<div class="px-4 py-2">
<h3 class="text-white text-lg font-bold leading-tight mb-3 flex items-center gap-2">
<span class="material-symbols-outlined text-primary">filter_list</span>
                Filtrar ubicación
            </h3>
<div class="grid grid-cols-2 gap-3">
<label class="relative block">
<span class="sr-only">Región</span>
<span class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none text-text-muted">
<span class="material-symbols-outlined text-[20px]">map</span>
</span>
<select class="block w-full bg-card-dark border border-[#543b41] text-white text-sm rounded-lg focus:ring-primary focus:border-primary block p-3 pl-10 appearance-none">
<option selected="">Región</option>
<option value="rm">Metropolitana</option>
<option value="v">Valparaíso</option>
<option value="viii">Biobío</option>
</select>
</label>
<label class="relative block">
<span class="sr-only">Comuna</span>
<span class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none text-text-muted">
<span class="material-symbols-outlined text-[20px]">location_on</span>
</span>
<select class="block w-full bg-card-dark border border-[#543b41] text-white text-sm rounded-lg focus:ring-primary focus:border-primary block p-3 pl-10 appearance-none">
<option selected="">Comuna</option>
<option value="provi">Providencia</option>
<option value="lascondes">Las Condes</option>
<option value="stgo">Santiago</option>
</select>
</label>
</div>
</div>
<!-- Horizontal Scroll Categories (Chips) -->
<div class="px-4 py-4 overflow-x-auto no-scrollbar">
<div class="flex gap-2">
<button class="whitespace-nowrap px-4 py-2 rounded-full bg-primary text-white text-sm font-semibold shadow-lg shadow-primary/25">Todo</button>
<button class="whitespace-nowrap px-4 py-2 rounded-full bg-card-dark border border-[#39282c] text-text-muted hover:text-white hover:border-primary/50 text-sm font-medium transition-colors">Nuevas</button>
<button class="whitespace-nowrap px-4 py-2 rounded-full bg-card-dark border border-[#39282c] text-text-muted hover:text-white hover:border-primary/50 text-sm font-medium transition-colors">Verificadas</button>
<button class="whitespace-nowrap px-4 py-2 rounded-full bg-card-dark border border-[#39282c] text-text-muted hover:text-white hover:border-primary/50 text-sm font-medium transition-colors">Premium</button>
</div>
</div>
<!-- Main Grid Content -->
<div class="px-4 pb-4">
<div class="flex items-center justify-between mb-4">
<h3 class="text-white text-xl font-bold">Modelos en tu zona</h3>
<a class="text-primary text-sm font-semibold hover:underline" href="#">Ver todas</a>
</div>
<div class="grid grid-cols-2 gap-4">
<!-- Card 1 -->
<div class="group relative rounded-xl overflow-hidden bg-card-dark aspect-[3/4]">
<div class="absolute inset-0 bg-cover bg-center transition-transform duration-500 group-hover:scale-110" data-alt="Portrait of a young woman with curly hair looking at camera" style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuDyMz2FraRKID8VhGPZXQfgPc7Nr6KK9Cb1oPI4zO0wMHHeLWz1kNYSzVPUjW5EIIhA43N9vy-JWFzXXCkRQJJzGgs06LqytTCgjfHE9AlzZ-e5LPrd6HqLTJf_6c_TaIddR4kBKMk-cggaKhTfcm6rnznCyf5p2s787xk_YaRBjhesj7H_6aSjXG56nQxzff1NgGB45oeTBDIyoQo7BBnYH6zYnhoP8CyPtqK_MIayYAzjVplM8iNHCNSYFKt0KMZ031p2rL0zxFfh')"></div>
<!-- Overlays -->
<div class="absolute top-2 left-2">
<span class="inline-flex items-center gap-1 bg-black/60 backdrop-blur-sm px-2 py-1 rounded text-[10px] font-bold text-secondary border border-secondary/30">
<span class="material-symbols-outlined text-[12px] filled">verified</span>
                            VERIFICADA
                        </span>
</div>
<div class="absolute inset-0 bg-gradient-to-t from-background-dark via-transparent to-transparent opacity-90"></div>
<div class="absolute bottom-0 left-0 w-full p-3">
<div class="flex justify-between items-end">
<div>
<h4 class="text-white font-bold text-lg leading-tight">Sofía, 24</h4>
<div class="flex items-center gap-1 text-text-muted text-xs mt-1">
<span class="material-symbols-outlined text-[14px]">location_on</span>
                                    Providencia
                                </div>
</div>
</div>
</div>
</div>
<!-- Card 2 -->
<div class="group relative rounded-xl overflow-hidden bg-card-dark aspect-[3/4] border border-secondary/40 shadow-[0_0_10px_rgba(212,175,55,0.1)]">
<div class="absolute inset-0 bg-cover bg-center transition-transform duration-500 group-hover:scale-110" data-alt="Fashion portrait of a woman posing against a colorful wall" style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuCiSoPJtHtAib6BLv7Zs_hvYbd24vu4TFLKhI_9SRc4AvXb9SDwenpQ4mXh-jtJTC8xbuKto2H_7ibgx2iI1dsnvt_UZkb4CAsIWMqxYG1KEroriGOnUGKoME1DsEhvFetC340mpo_XWO93dGv6fRF9DWmERbraqXk7P75xZkRq9y6hgqjbsGUjiQucTEdLA1DiBIhdOEIEaA_-Qk0gHZNVHmBHH5Onb-JfTIstp5jTl0fCdHXRdropJIc3hoFS7alEPLK5bkHGIkd0')"></div>
<div class="absolute top-2 left-2 flex flex-col gap-1">
<span class="inline-flex items-center gap-1 bg-secondary text-black px-2 py-1 rounded text-[10px] font-bold">
                            PREMIUM
                        </span>
</div>
<div class="absolute top-2 right-2">
<div class="size-2 rounded-full bg-green-500 shadow-[0_0_8px_rgba(34,197,94,0.6)]"></div>
</div>
<div class="absolute inset-0 bg-gradient-to-t from-background-dark via-transparent to-transparent opacity-90"></div>
<div class="absolute bottom-0 left-0 w-full p-3">
<h4 class="text-white font-bold text-lg leading-tight text-secondary">Isabella, 22</h4>
<div class="flex items-center gap-1 text-text-muted text-xs mt-1">
<span class="material-symbols-outlined text-[14px]">location_on</span>
                            Las Condes
                        </div>
</div>
</div>
<!-- Card 3 -->
<div class="group relative rounded-xl overflow-hidden bg-card-dark aspect-[3/4]">
<div class="absolute inset-0 bg-cover bg-center transition-transform duration-500 group-hover:scale-110" data-alt="Close up portrait of a woman with natural makeup" style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuC3nSbdxeNwP59HSS1noXjWI5lh2CIdUFYrgvbj3kXqlQ64X25DiDhejbDEnxA-6Ga4x_HMi4fpGuCWUm4If9xvD3pVXPtI4nCL1gTATqoR-YM7Mnfx3NMkzMgbc0IRh5mjuXVmX8gGB8HzTqExpmCW2MHlg0h4zehMLQHbK926rFjR-D2MSyILfkDGQD_CRpMJLgPd0RXHllJI11_5_wMTeCswaIOZ4pP26IGTzDbTYhEwD9y7h8PdQrUuwHhHQugmG3V0MwXwFC-i')"></div>
<div class="absolute top-2 left-2">
<span class="inline-flex items-center gap-1 bg-primary text-white px-2 py-1 rounded text-[10px] font-bold shadow-lg shadow-primary/30">
                            NUEVA
                        </span>
</div>
<div class="absolute inset-0 bg-gradient-to-t from-background-dark via-transparent to-transparent opacity-90"></div>
<div class="absolute bottom-0 left-0 w-full p-3">
<h4 class="text-white font-bold text-lg leading-tight">Martina, 21</h4>
<div class="flex items-center gap-1 text-text-muted text-xs mt-1">
<span class="material-symbols-outlined text-[14px]">location_on</span>
                            Ñuñoa
                        </div>
</div>
</div>
<!-- Card 4 -->
<div class="group relative rounded-xl overflow-hidden bg-card-dark aspect-[3/4]">
<div class="absolute inset-0 bg-cover bg-center transition-transform duration-500 group-hover:scale-110" data-alt="Stylish woman in sunglasses looking sideways" style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuCMcQS7Vci7psngdL4JLBR122b7y3_RBO0yEsU0aGJY4RMd_Lp92LZdUDVNeUy_sz3weC25RYujRk-lpzoc17fkpH1riwsKjWZ86E9xn3SKNouIiwH2ANmhqHFVD0tq5Oxayek0unyyFls3x12JNs7HZ_9_ZhsiPCtfsTphakEhiry0a-9KxLFRwKdsc7nbK4KUvNO1VlAgPbSO-E5r0mtbfqjZXaarSUiiYnmqUcHQDz4w3G7j-vGu9fjCCEs5C60ONjjC23XFHac2')"></div>
<div class="absolute inset-0 bg-gradient-to-t from-background-dark via-transparent to-transparent opacity-90"></div>
<div class="absolute bottom-0 left-0 w-full p-3">
<div class="flex items-center gap-1 mb-1">
<h4 class="text-white font-bold text-lg leading-tight">Camila, 25</h4>
<span class="material-symbols-outlined text-primary text-[16px] filled">verified</span>
</div>
<div class="flex items-center gap-1 text-text-muted text-xs">
<span class="material-symbols-outlined text-[14px]">location_on</span>
                            Vitacura
                        </div>
</div>
</div>
<!-- Card 5 -->
<div class="group relative rounded-xl overflow-hidden bg-card-dark aspect-[3/4]">
<div class="absolute inset-0 bg-cover bg-center transition-transform duration-500 group-hover:scale-110" data-alt="Woman smiling with closed eyes, side profile" style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuBOsN0bxWMojhWhoo4R6SSV7ZbTBZqO54ZaeJUp1EfpqbAPs42kiAtH_W2A3FRuihoxIoq-4F5cBfX3lkgrmFuS_GlD_KJn1lNlefE-FH2DJChfZzdYZG47bPNkjZ5ZyJDn7cgAi9xquIRMRf6PfHaiVnv7fJfX_WVsjqQZW_60vx7gGu87jBBqMQEY2kBojpiPoy299DszY1XvzmuYXGkkvdFhLucKXJx_0BsJHXYpf2S_tPwIwwjp1vAJ5Hn0cD39E8GpYZktUjf6')"></div>
<div class="absolute inset-0 bg-gradient-to-t from-background-dark via-transparent to-transparent opacity-90"></div>
<div class="absolute bottom-0 left-0 w-full p-3">
<div class="flex items-center gap-1 mb-1">
<h4 class="text-white font-bold text-lg leading-tight">Valentina, 23</h4>
</div>
<div class="flex items-center gap-1 text-text-muted text-xs">
<span class="material-symbols-outlined text-[14px]">location_on</span>
                            Santiago Centro
                        </div>
</div>
</div>
<!-- Card 6 -->
<div class="group relative rounded-xl overflow-hidden bg-card-dark aspect-[3/4]">
<div class="absolute inset-0 bg-cover bg-center transition-transform duration-500 group-hover:scale-110" data-alt="Portrait of a woman with pink hair and confident expression" style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuDndFw24ta_FbXL573MrPzBPv10gLsLQ7nnM2gHeExvFiF9vJO6-GkX9b0vWsFh41e2QLy1DNCEDUkN4E08LDADdcNmTbx4mWlKa5VuZqcICJ83Y0qd0ePHdekPk7i_Uv6CWTy-KTABz8Jx_KKU47l5KJVbIiel_EVHNopV6Y6sTNY2PDVaWCnriNM6Ky56B_dv53Vqlp9yE37LWi79Fq42sJFdb6Ex-fXMnAC28r-d31K819g2_K5iC1j3Oljx8LkoWVkMEYTeMeHz')"></div>
<div class="absolute top-2 left-2">
<span class="inline-flex items-center gap-1 bg-black/60 backdrop-blur-sm px-2 py-1 rounded text-[10px] font-bold text-secondary border border-secondary/30">
<span class="material-symbols-outlined text-[12px] filled">verified</span>
                            VERIFICADA
                        </span>
</div>
<div class="absolute inset-0 bg-gradient-to-t from-background-dark via-transparent to-transparent opacity-90"></div>
<div class="absolute bottom-0 left-0 w-full p-3">
<div class="flex items-center gap-1 mb-1">
<h4 class="text-white font-bold text-lg leading-tight">Antonia, 20</h4>
</div>
<div class="flex items-center gap-1 text-text-muted text-xs">
<span class="material-symbols-outlined text-[14px]">location_on</span>
                            La Reina
                        </div>
</div>
</div>
</div>
<div class="mt-6 flex justify-center">
<button class="w-full py-3 bg-[#39282c] text-white rounded-lg text-sm font-bold hover:bg-[#543b41] transition-colors flex items-center justify-center gap-2">
                    Cargar más modelos
                    <span class="material-symbols-outlined text-[18px]">expand_more</span>
</button>
</div>
</div>
<!-- FAB for Mobile (Optional CTA) -->
<button class="fixed bottom-24 right-4 z-40 size-14 rounded-full bg-primary text-white shadow-xl shadow-primary/30 flex items-center justify-center hover:scale-105 transition-transform">
<span class="material-symbols-outlined text-[28px]">search</span>
</button>
<!-- Bottom Navigation Bar -->
<nav class="fixed bottom-0 left-0 w-full max-w-md left-1/2 -translate-x-1/2 glass-nav border-t border-[#39282c] pb-safe z-50">
<div class="flex justify-around items-center h-16 px-2">
<a class="flex flex-col items-center gap-1 w-full text-primary" href="#">
<span class="material-symbols-outlined filled text-[24px]">home</span>
<span class="text-[10px] font-medium">Inicio</span>
</a>
<a class="flex flex-col items-center gap-1 w-full text-text-muted hover:text-white transition-colors" href="#">
<span class="material-symbols-outlined text-[24px]">favorite</span>
<span class="text-[10px] font-medium">Favoritos</span>
</a>
<a class="flex flex-col items-center gap-1 w-full text-text-muted hover:text-white transition-colors" href="#">
<span class="material-symbols-outlined text-[24px]">grid_view</span>
<span class="text-[10px] font-medium">Categorías</span>
</a>
<a class="flex flex-col items-center gap-1 w-full text-text-muted hover:text-white transition-colors" href="#">
<span class="material-symbols-outlined text-[24px]">person</span>
<span class="text-[10px] font-medium">Perfil</span>
</a>
</div>
</nav>
<!-- Safe area padding helper for iOS -->
<div class="h-6 w-full"></div>
</div>
</body></html>