<!DOCTYPE html>
<html class="dark" lang="es">
<head>
    <meta charset="utf-8"/>
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <title><?= $titulo ?? 'Panel Admin' ?> - Calientitas</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&family=Plus+Jakarta+Sans:wght@400;500;700;800&display=swap" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1" rel="stylesheet"/>
    
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
    <script>
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#ee2b5b",
                        "background-dark": "#121212", 
                        "surface-dark": "#1a1a1a",    
                        "surface-hover": "#262626",
                        "gold": "#FFD700",
                        "text-muted": "#9ca3af",
                        "border-dark": "#2d2d2d"
                    },
                    fontFamily: {
                        "sans": ["Poppins", "sans-serif"],
                        "display": ["Plus Jakarta Sans", "sans-serif"]
                    }
                },
            },
        }
    </script>
    <style type="text/tailwindcss">
        @layer base {
            body { @apply bg-background-dark text-white font-sans selection:bg-primary/30; }
        }
        [x-cloak] { display: none !important; }
        .custom-scrollbar::-webkit-scrollbar { width: 6px; }
        .custom-scrollbar::-webkit-scrollbar-track { background: #1a1a1a; }
        .custom-scrollbar::-webkit-scrollbar-thumb { background: #333; border-radius: 10px; }
    </style>
</head>
<body class="overflow-hidden" x-data="{ mobileMenuOpen: false }">
<div class="flex h-screen w-full relative">
    
    <aside class="hidden w-72 flex-col border-r border-border-dark bg-background-dark lg:flex shrink-0">
        <div class="flex h-full flex-col justify-between p-6">
            <div class="flex flex-col gap-8">
                <div class="flex items-center gap-3 px-2">
                    <div class="flex h-10 w-10 items-center justify-center rounded-full bg-gradient-to-br from-primary to-purple-600">
                        <span class="material-symbols-outlined text-white" style="font-size: 24px;">shield_person</span>
                    </div>
                    <span class="text-xl font-extrabold tracking-tight text-white uppercase italic">ADMIN PANEL</span>
                </div>

                <div class="px-4 py-2 bg-primary/10 rounded-xl border border-primary/20">
                    <p class="text-[10px] font-black text-primary uppercase tracking-widest">Administrador</p>
                    <p class="text-sm font-bold truncate text-white"><?= session()->get('nombre') ?></p>
                </div>

                <nav class="flex flex-col gap-1.5">
                    <p class="px-4 text-[10px] font-black text-gray-600 uppercase tracking-widest mb-2">Principal</p>
                    
                    <a href="<?= base_url('admin/dashboard') ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?= (uri_string() == 'admin/dashboard') ? 'bg-surface-hover border border-primary/20 text-white shadow-sm' : 'text-text-muted hover:bg-surface-hover hover:text-white' ?>">
                        <span class="material-symbols-outlined text-lg <?= (uri_string() == 'admin/dashboard') ? 'text-primary font-variation-settings: \'FILL\' 1' : '' ?>">dashboard</span>
                        <p class="text-sm font-medium">Dashboard</p>
                    </a>

                    <a href="<?= base_url('admin/modelos') ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?= (uri_string() == 'admin/modelos') ? 'bg-surface-hover border border-primary/20 text-white shadow-sm' : 'text-text-muted hover:bg-surface-hover hover:text-white' ?>">
                        <span class="material-symbols-outlined text-lg <?= (uri_string() == 'admin/modelos') ? 'text-primary' : '' ?>">group</span>
                        <p class="text-sm font-medium">Gesti&oacute;n Modelos</p>
                    </a>

                    <a href="<?= base_url('admin/verificaciones') ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?= (uri_string() == 'admin/verificaciones') ? 'bg-surface-hover border border-primary/20 text-white shadow-sm' : 'text-text-muted hover:bg-surface-hover hover:text-white' ?>">
                        <span class="material-symbols-outlined text-lg <?= (uri_string() == 'admin/verificaciones') ? 'text-gold' : '' ?>">verified_user</span>
                        <p class="text-sm font-medium">Verificaciones</p>
                    </a>

                    <a href="<?= base_url('admin/resenas') ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?= (uri_string() == 'admin/resenas') ? 'bg-surface-hover border border-primary/20 text-white shadow-sm' : 'text-text-muted hover:bg-surface-hover hover:text-white' ?>">
                        <span class="material-symbols-outlined text-lg <?= (uri_string() == 'admin/resenas') ? 'text-primary' : '' ?>">reviews</span>
                        <p class="text-sm font-medium">Rese&ntilde;as</p>
                    </a>
                </nav>
            </div>

            <a href="<?= base_url('logout') ?>" class="flex w-full items-center gap-3 rounded-xl px-4 py-3 text-text-muted hover:bg-red-500/10 hover:text-red-500 transition-colors">
                <span class="material-symbols-outlined text-lg">logout</span>
                <span class="text-sm font-medium">Cerrar Sesi&oacute;n</span>
            </a>
        </div>
    </aside>

    <div x-show="mobileMenuOpen" x-cloak class="fixed inset-0 z-[100] lg:hidden">
        <div x-show="mobileMenuOpen" x-transition:enter="transition-opacity ease-linear duration-300" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="transition-opacity ease-linear duration-300" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" @click="mobileMenuOpen = false" class="fixed inset-0 bg-black/80 backdrop-blur-sm"></div>

        <div x-show="mobileMenuOpen" x-transition:enter="transition ease-in-out duration-300 transform" x-transition:enter-start="-translate-x-full" x-transition:enter-end="translate-x-0" x-transition:leave="transition ease-in-out duration-300 transform" x-transition:leave-start="translate-x-0" x-transition:leave-end="-translate-x-full" class="relative flex w-full max-w-xs flex-1 flex-col bg-background-dark border-r border-border-dark h-full p-6">
            <div class="flex items-center justify-between mb-8">
                <div class="flex items-center gap-2">
                    <span class="material-symbols-outlined text-primary">shield_person</span>
                    <span class="text-lg font-black italic uppercase">Admin</span>
                </div>
                <button @click="mobileMenuOpen = false" class="text-white"><span class="material-symbols-outlined">close</span></button>
            </div>

            <nav class="flex flex-col gap-2">
                <a @click="mobileMenuOpen = false" href="<?= base_url('admin/dashboard') ?>" class="flex items-center gap-4 px-4 py-4 rounded-2xl bg-surface-dark border border-white/5">
                    <span class="material-symbols-outlined text-primary">dashboard</span> Dashboard
                </a>
                <a @click="mobileMenuOpen = false" href="<?= base_url('admin/modelos') ?>" class="flex items-center gap-4 px-4 py-4 rounded-2xl">
                    <span class="material-symbols-outlined text-muted">group</span> Modelos
                </a>
                <a @click="mobileMenuOpen = false" href="<?= base_url('admin/verificaciones') ?>" class="flex items-center gap-4 px-4 py-4 rounded-2xl">
                    <span class="material-symbols-outlined text-gold">verified_user</span> Verificaciones
                </a>
                <a @click="mobileMenuOpen = false" href="<?= base_url('admin/resenas') ?>" class="flex items-center gap-4 px-4 py-4 rounded-2xl">
                    <span class="material-symbols-outlined text-muted">reviews</span> Rese&ntilde;as
                </a>
            </nav>

            <a href="<?= base_url('logout') ?>" class="mt-auto flex items-center gap-4 px-4 py-4 text-red-500 font-bold border-t border-white/5">
                <span class="material-symbols-outlined">logout</span> Salir
            </a>
        </div>
    </div>

    <main class="flex flex-1 flex-col overflow-y-auto bg-background-dark custom-scrollbar">
        <div class="lg:hidden flex items-center justify-between p-4 bg-surface-dark border-b border-border-dark shrink-0 sticky top-0 z-40">
            <div class="flex items-center gap-2">
                <span class="material-symbols-outlined text-primary">shield_person</span>
                <span class="text-sm font-black uppercase italic tracking-tighter">Admin Panel</span>
            </div>
            <button @click="mobileMenuOpen = true" class="text-white p-2">
                <span class="material-symbols-outlined text-3xl">menu</span>
            </button>
        </div>

        <div class="w-full">
            <?= $this->renderSection('content') ?>
        </div>
    </main>
</div>
</body>
</html>