<!DOCTYPE html>
<html class="dark" lang="es">
<head>
    <meta charset="utf-8"/>
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <title><?= $titulo ?? 'Calientitas.cl' ?></title>
<!-- Fonts -->
<link href="https://fonts.googleapis.com" rel="preconnect"/>
<link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
<link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&amp;display=swap" rel="stylesheet"/>
<link href="https://fonts.googleapis.com/css2?family=Noto+Sans:wght@400;500;700&amp;display=swap" rel="stylesheet"/>
<!-- Material Symbols -->
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&amp;display=swap" rel="stylesheet"/>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&amp;display=swap" rel="stylesheet"/>
<!-- Tailwind CSS -->
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
<!-- Tailwind Config -->
<script id="tailwind-config">
    tailwind.config = {
        darkMode: "class",
        theme: {
            extend: {
                colors: {
                    "primary": "#ee2b5b",
                    "background-light": "#f8f6f6",
                    "background-dark": "#221015",
                    "surface-dark": "#181113",
                    "surface-accent": "#39282c",
                    "gold": "#FFD700",
                },
                fontFamily: {
                    "display": ["Plus Jakarta Sans", "sans-serif"],
                    "body": ["Noto Sans", "sans-serif"],
                },
                borderRadius: {"DEFAULT": "0.25rem", "lg": "0.5rem", "xl": "0.75rem", "full": "9999px"},
            },
        },
    }
</script>
<style>
    .scrollbar-hide::-webkit-scrollbar {
        display: none;
    }
    .scrollbar-hide {
        -ms-overflow-style: none;
        scrollbar-width: none;
    }
    /* Ocultar scrollbar pero mantener scroll funcional */
    .scrollbar-hide::-webkit-scrollbar {
        display: none;
    }
    .scrollbar-hide {
        -ms-overflow-style: none;
        scrollbar-width: none;
    }
    
    /* Efecto de transición para el Hero */
    #main-hero-img {
        transition: opacity 0.3s ease-in-out;
    }
    html { scroll-behavior: smooth; }
    .story-ring {
        background: linear-gradient(45deg, #f09433 0%, #e6683c 25%, #dc2743 50%, #cc2366 75%, #bc1888 100%);
        padding: 3px;
        border-radius: 9999px;
        display: inline-block;
    }
    .story-inner {
        border: 3px solid white; /* Ajusta a dark:border-[#1a0f11] si prefieres */
        border-radius: 9999px;
        overflow: hidden;
    }
</style>
</head>
<body class="relative flex h-auto min-h-screen w-full flex-col bg-background-light dark:bg-background-dark font-display text-gray-900 dark:text-white overflow-x-hidden">
<!-- Navbar -->
<?= $this->include('includes/header') ?>

    <main>
        <?= $this->renderSection('content') ?>
    </main>

<!-- Footer -->
<footer class="bg-background-dark border-t border-surface-border pt-16 pb-8 px-6 lg:px-20">
    <div class="max-w-[1440px] mx-auto grid grid-cols-1 md:grid-cols-4 gap-10 mb-12">
        <div class="col-span-1 md:col-span-1">
            <div class="flex items-center gap-2 text-white mb-4">
                <span class="material-symbols-outlined text-primary text-[24px]">local_fire_department</span>
                <h2 class="text-lg font-bold">Calientitas</h2>
            </div>
            <p class="text-gray-500 text-sm mb-4">La plataforma l&iacute;der en anuncios de modelos independientes en Chile. Seguridad y confianza garantizada.</p>
            <div class="flex gap-4">
                <a class="text-gray-400 hover:text-white" href="#"><span class="material-symbols-outlined">public</span></a>
                <a class="text-gray-400 hover:text-white" href="#"><span class="material-symbols-outlined">mail</span></a>
            </div>
        </div>
        <div>
            <h3 class="text-white font-bold mb-4">Plataforma</h3>
            <ul class="space-y-2 text-gray-500 text-sm">
                <li><a class="hover:text-primary" href="#">Inicio</a></li>
                <li><a class="hover:text-primary" href="#">Novedades</a></li>
                <li><a class="hover:text-primary" href="#">Ranking Top 30</a></li>
                <li><a class="hover:text-primary" href="#">Categoría VIP</a></li>
            </ul>
        </div>
        <div>
            <h3 class="text-white font-bold mb-4">Soporte</h3>
            <ul class="space-y-2 text-gray-500 text-sm">
                <li><a class="hover:text-primary" href="#">Centro de Ayuda</a></li>
                <li><a class="hover:text-primary" href="#">Publicar Aviso</a></li>
                <li><a class="hover:text-primary" href="#">Reportar Problema</a></li>
                <li><a class="hover:text-primary" href="#">Contacto</a></li>
            </ul>
        </div>
        <div>
            <h3 class="text-white font-bold mb-4">Legal</h3>
            <ul class="space-y-2 text-gray-500 text-sm">
                <li><a class="hover:text-primary" href="#">T&eacute;rminos y Condiciones</a></li>
                <li><a class="hover:text-primary" href="#">Privacidad</a></li>
                <li><a class="hover:text-primary" href="#">Pol&iacute;tica de Cookies</a></li>
            </ul>
        </div>
    </div>
    <div class="max-w-[1440px] mx-auto border-t border-surface-border pt-8 flex flex-col md:flex-row justify-between items-center gap-4">
        <p class="text-gray-600 text-xs">© 2024 - <?= date('Y') ?> Calientitas. Todos los derechos reservados.</p>
        <div class="bg-surface-dark px-3 py-1 rounded border border-surface-border">
            <p class="text-gray-400 text-xs font-bold flex items-center gap-1">
                <span class="text-primary text-sm">18+</span> Contenido para adultos
            </p>
        </div>
    </div>
</footer>
</div>
</body>
</html>