<!DOCTYPE html>
<html class="dark" lang="es">
<head>
    <meta charset="utf-8"/>
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <title><?= $titulo ?? 'Calientitas.cl' ?></title>
    <link href="https://fonts.googleapis.com" rel="preconnect"/>
    <link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&family=Noto+Sans:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&display=swap" rel="stylesheet"/>
    
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
    
    <script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#ee2b5b",
                        "gold": "#D4AF37",
                        "gold-light": "#F3E5AB",
                        "background-light": "#f8f6f6",
                        "background-dark": "#181113",
                        "surface-dark": "#271c1e",
                        "surface-border": "#39282c",
                    },
                    fontFamily: {
                        "display": ["Plus Jakarta Sans", "sans-serif"],
                        "body": ["Noto Sans", "sans-serif"],
                    },
                    borderRadius: {"DEFAULT": "0.25rem", "lg": "0.5rem", "xl": "0.75rem", "2xl": "1rem", "full": "9999px"},
                },
            },
        }
    </script>
    <style>
        ::-webkit-scrollbar { width: 8px; }
        ::-webkit-scrollbar-track { background: #181113; }
        ::-webkit-scrollbar-thumb { background: #39282c; border-radius: 4px; }
        ::-webkit-scrollbar-thumb:hover { background: #ee2b5b; }
        
        @keyframes pulse-green {
            0% { box-shadow: 0 0 0 0 rgba(74, 222, 128, 0.7); }
            70% { box-shadow: 0 0 0 6px rgba(74, 222, 128, 0); }
            100% { box-shadow: 0 0 0 0 rgba(74, 222, 128, 0); }
        }
        .status-pulse { animation: pulse-green 2s infinite; }

        /* Prevenir scroll cuando el menú está abierto */
        .no-scroll { overflow: hidden; }
    </style>
</head>
<body 
    x-data="{ mobileMenuOpen: false }" 
    :class="{ 'no-scroll': mobileMenuOpen }"
    class="bg-background-light dark:bg-background-dark text-slate-900 dark:text-white font-display overflow-x-hidden selection:bg-primary selection:text-white"
>

<div class="relative flex min-h-screen w-full flex-col group/design-root">
    
    <?= $this->include('includes/header') ?>

    <template x-teleport="body">
        <div 
            x-show="mobileMenuOpen" 
            class="fixed inset-0 z-[100] lg:hidden" 
            x-cloak
        >
            <div 
                x-show="mobileMenuOpen"
                x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0"
                x-transition:enter-end="opacity-100"
                x-transition:leave="transition ease-in duration-300"
                x-transition:leave-start="opacity-100"
                x-transition:leave-end="opacity-0"
                @click="mobileMenuOpen = false"
                class="absolute inset-0 bg-black/80 backdrop-blur-sm"
            ></div>

            <div 
                x-show="mobileMenuOpen"
                x-transition:enter="transition ease-in-out duration-300 transform"
                x-transition:enter-start="-translate-x-full"
                x-transition:enter-end="translate-x-0"
                x-transition:leave="transition ease-in-out duration-300 transform"
                x-transition:leave-start="translate-x-0"
                x-transition:leave-end="-translate-x-full"
                class="absolute inset-y-0 left-0 w-full max-w-xs bg-background-dark border-r border-surface-border shadow-2xl flex flex-col p-6"
            >
                <div class="flex items-center justify-between mb-10">
                    <div class="flex items-center gap-2">
                        <span class="material-symbols-outlined text-primary text-3xl">local_fire_department</span>
                        <h2 class="text-xl font-black uppercase italic tracking-tighter">Calientitas</h2>
                    </div>
                    <button @click="mobileMenuOpen = false" class="text-gray-400 hover:text-white">
                        <span class="material-symbols-outlined">close</span>
                    </button>
                </div>

                <nav class="flex flex-col gap-2">
                    <a href="<?= base_url('buscar') ?>" class="flex items-center gap-4 p-4 rounded-2xl bg-primary/10 border border-primary/20 text-white font-black uppercase tracking-widest text-xs group">
                        <span class="material-symbols-outlined text-primary group-hover:scale-110 transition-transform">search</span> 
                        Explorar Modelos
                    </a>
                    <a href="<?= base_url() ?>" class="flex items-center gap-4 p-4 rounded-2xl bg-surface-dark border border-surface-border text-white font-bold">
                        <span class="material-symbols-outlined text-primary">home</span> Inicio
                    </a>
                    <a href="<?= base_url('ranking') ?>" class="flex items-center gap-4 p-4 rounded-2xl hover:bg-surface-dark transition-colors">
                        <span class="material-symbols-outlined text-gold">workspace_premium</span> Ranking Top 30
                    </a>
                    <a href="<?= base_url('novedades') ?>" class="flex items-center gap-4 p-4 rounded-2xl hover:bg-surface-dark transition-colors">
                        <span class="material-symbols-outlined">new_releases</span> Novedades
                    </a>
                    <a href="<?= base_url('vip') ?>" class="flex items-center gap-4 p-4 rounded-2xl hover:bg-surface-dark transition-colors">
                        <span class="material-symbols-outlined">star</span> Modelos VIP
                    </a>
                </nav>

                <div class="mt-auto pt-6 border-t border-surface-border space-y-4">
                    <?php if(!session()->get('isLoggedIn')): ?>
                        <a href="<?= base_url('login') ?>" class="flex items-center justify-center w-full py-4 rounded-2xl font-black bg-surface-dark border border-surface-border text-white">INICIAR SESIÓN</a>
                        <a href="<?= base_url('registro') ?>" class="flex items-center justify-center w-full py-4 rounded-2xl font-black bg-primary text-white shadow-lg shadow-primary/20">PUBLICAR AVISO</a>
                    <?php else: ?>
                        <a href="<?= base_url('modelo/dashboard') ?>" class="flex items-center justify-center w-full py-4 rounded-2xl font-black bg-primary text-white">MI PANEL</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </template>
    <main>
        <?= $this->renderSection('content') ?>
    </main>

<!-- Footer -->
<footer class="bg-background-dark border-t border-surface-border pt-16 pb-8 px-6 lg:px-20">
    <div class="max-w-[1440px] mx-auto grid grid-cols-1 md:grid-cols-4 gap-10 mb-12">
        <div class="col-span-1 md:col-span-1">
            <div class="flex items-center gap-2 text-white mb-4">
                <span class="material-symbols-outlined text-primary text-[24px]">local_fire_department</span>
                <h2 class="text-lg font-bold">Calientitas</h2>
            </div>
            <p class="text-gray-500 text-sm mb-4">La plataforma l&iacute;der en anuncios de modelos independientes en Chile. Seguridad y confianza garantizada.</p>
            <div class="flex gap-4">
                <a class="text-gray-400 hover:text-white" href="#"><span class="material-symbols-outlined">public</span></a>
                <a class="text-gray-400 hover:text-white" href="#"><span class="material-symbols-outlined">mail</span></a>
            </div>
        </div>
        <div>
            <h3 class="text-white font-bold mb-4">Plataforma</h3>
            <ul class="space-y-2 text-gray-500 text-sm">
                <li><a class="hover:text-primary" href="#">Inicio</a></li>
                <li><a class="hover:text-primary" href="#">Novedades</a></li>
                <li><a class="hover:text-primary" href="#">Ranking Top 30</a></li>
                <li><a class="hover:text-primary" href="#">Categoría VIP</a></li>
            </ul>
        </div>
        <div>
            <h3 class="text-white font-bold mb-4">Soporte</h3>
            <ul class="space-y-2 text-gray-500 text-sm">
                <li><a class="hover:text-primary" href="#">Centro de Ayuda</a></li>
                <li><a class="hover:text-primary" href="#">Publicar Aviso</a></li>
                <li><a class="hover:text-primary" href="#">Reportar Problema</a></li>
                <li><a class="hover:text-primary" href="#">Contacto</a></li>
            </ul>
        </div>
        <div>
            <h3 class="text-white font-bold mb-4">Legal</h3>
            <ul class="space-y-2 text-gray-500 text-sm">
                <li><a class="hover:text-primary" href="#">T&eacute;rminos y Condiciones</a></li>
                <li><a class="hover:text-primary" href="#">Privacidad</a></li>
                <li><a class="hover:text-primary" href="#">Pol&iacute;tica de Cookies</a></li>
            </ul>
        </div>
    </div>
    <div class="max-w-[1440px] mx-auto border-t border-surface-border pt-8 flex flex-col md:flex-row justify-between items-center gap-4">
        <p class="text-gray-600 text-xs">© 2024 - <?= date('Y') ?> Calientitas. Todos los derechos reservados.</p>
        <div class="bg-surface-dark px-3 py-1 rounded border border-surface-border">
            <p class="text-gray-400 text-xs font-bold flex items-center gap-1">
                <span class="text-primary text-sm">18+</span> Contenido para adultos
            </p>
        </div>
    </div>
</footer>
</div>
</body>
</html>