<!DOCTYPE html>
<html class="dark" lang="es">
<head>
    <meta charset="utf-8"/>
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <title><?= $titulo ?? 'Dashboard' ?> - Calientitas</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&family=Plus+Jakarta+Sans:wght@400;500;700;800&display=swap" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1" rel="stylesheet"/>
    
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    
    <script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
    <script>
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#ee2b5b",
                        "primary-hover": "#d9204d",
                        "background-dark": "#121212", 
                        "surface-dark": "#1a1a1a",    
                        "surface-hover": "#262626",
                        "gold": "#FFD700",
                        "gold-hover": "#E6C200",
                        "text-muted": "#9ca3af",
                        "border-dark": "#2d2d2d"
                    },
                    fontFamily: {
                        "sans": ["Poppins", "sans-serif"],
                        "display": ["Plus Jakarta Sans", "sans-serif"]
                    },
                    borderRadius: { "xl": "1rem", "2xl": "1.5rem" },
                },
            },
        }
    </script>
    <style type="text/tailwindcss">
        @layer base {
            body { @apply bg-background-dark text-white font-sans selection:bg-primary/30; }
        }
        [x-cloak] { display: none !important; }
        .custom-scrollbar::-webkit-scrollbar { width: 6px; }
        .custom-scrollbar::-webkit-scrollbar-track { background: #1a1a1a; }
        .custom-scrollbar::-webkit-scrollbar-thumb { background: #333; border-radius: 10px; }
    </style>
</head>
<body class="overflow-hidden" x-data="{ mobileMenuOpen: false }">
<div class="flex h-screen w-full relative">
    
    <aside class="hidden w-72 flex-col border-r border-border-dark bg-background-dark lg:flex shrink-0">
        <div class="flex h-full flex-col justify-between p-6">
            <div class="flex flex-col gap-8">
                <div class="flex items-center gap-3 px-2">
                    <div class="flex h-10 w-10 items-center justify-center rounded-full bg-gradient-to-br from-primary to-gold">
                        <span class="material-symbols-outlined text-white" style="font-size: 24px;">local_fire_department</span>
                    </div>
                    <span class="text-xl font-extrabold tracking-tight text-white uppercase italic">CALIENTITAS</span>
                </div>

                <div class="flex flex-col gap-3">
                    <div class="flex items-center gap-3 rounded-xl bg-surface-dark p-3 border border-border-dark">
                        <div class="bg-center bg-no-repeat aspect-square bg-cover rounded-full size-12 ring-2 ring-primary/30" 
                             style='background-image: url("<?= base_url('uploads/modelos/' . ($modelo['foto_principal'] ?? 'default.png')) ?>");'>
                        </div>
                        <div class="flex flex-col overflow-hidden text-left">
                            <h1 class="text-white text-sm font-bold truncate"><?= $usuario ?></h1>
                            <div class="flex items-center gap-1">
                                <span class="size-2 rounded-full bg-emerald-500"></span>
                                <p class="text-text-muted text-[10px] font-medium uppercase tracking-wider">
                                    <?= (($modelo['verificada'] ?? 0) == 1) ? 'Verificada' : 'Modelo' ?>
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <?php if(!empty($modelo['slug'])): ?>
                        <a href="<?= base_url('modelo/' . $modelo['slug']) ?>" target="_blank" 
                           class="flex items-center justify-center gap-2 w-full py-2 rounded-lg bg-white/5 border border-white/10 hover:bg-white/10 transition-all group">
                            <span class="material-symbols-outlined text-sm text-gold group-hover:scale-110 transition-transform">visibility</span>
                            <span class="text-[10px] font-black uppercase tracking-widest text-white/70 group-hover:text-white">Ver Perfil P&uacute;blico</span>
                        </a>
                    <?php endif; ?>
                </div>

                <nav class="flex flex-col gap-1.5">
                    <a href="<?= base_url('modelo/dashboard') ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?= (uri_string() == 'modelo/dashboard') ? 'bg-surface-hover border border-primary/20 text-white shadow-sm' : 'text-text-muted hover:bg-surface-hover hover:text-white' ?>">
                        <span class="material-symbols-outlined text-lg <?= (uri_string() == 'modelo/dashboard') ? 'text-primary' : '' ?>">dashboard</span>
                        <p class="text-sm font-medium">Dashboard</p>
                    </a>
                    <a href="<?= base_url('modelo/editar-ficha') ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?= (uri_string() == 'modelo/editar-ficha') ? 'bg-surface-hover border border-primary/20 text-white shadow-sm' : 'text-text-muted hover:bg-surface-hover hover:text-white' ?>">
                        <span class="material-symbols-outlined text-lg <?= (uri_string() == 'modelo/editar-ficha') ? 'text-primary' : '' ?>">person_edit</span>
                        <p class="text-sm font-medium">Editar Perfil</p>
                    </a>
                    <a href="<?= base_url('modelo/planes') ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?= (uri_string() == 'modelo/planes') ? 'bg-surface-hover border border-primary/20 text-white shadow-sm' : 'text-text-muted hover:bg-surface-hover hover:text-white' ?>">
                        <span class="material-symbols-outlined text-lg <?= (uri_string() == 'modelo/planes') ? 'text-primary' : '' ?>">subscriptions</span>
                        <p class="text-sm font-medium">Planes y VIP</p>
                    </a>
                    <a href="<?= base_url('modelo/historias') ?>" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?= (uri_string() == 'modelo/historias') ? 'bg-surface-hover border border-primary/20 text-white shadow-sm' : 'text-text-muted hover:bg-surface-hover hover:text-white' ?>">
                        <span class="material-symbols-outlined text-lg <?= (uri_string() == 'modelo/historias') ? 'text-primary' : '' ?>">history_toggle_off</span>
                        <p class="text-sm font-medium">Subir Historias</p>
                    </a>
                </nav>
            </div>

            <a href="<?= base_url('logout') ?>" class="flex w-full items-center gap-3 rounded-xl px-4 py-3 text-text-muted hover:bg-surface-hover hover:text-white transition-colors">
                <span class="material-symbols-outlined text-lg">logout</span>
                <span class="text-sm font-medium">Cerrar Sesi&oacute;n</span>
            </a>
        </div>
    </aside>

    <div x-show="mobileMenuOpen" 
         x-cloak 
         class="fixed inset-0 z-[100] lg:hidden" 
         role="dialog" aria-modal="true">
        
        <div x-show="mobileMenuOpen" 
             x-transition:enter="transition-opacity ease-linear duration-300" 
             x-transition:enter-start="opacity-0" 
             x-transition:enter-end="opacity-100" 
             x-transition:leave="transition-opacity ease-linear duration-300" 
             x-transition:leave-start="opacity-100" 
             x-transition:leave-end="opacity-0" 
             @click="mobileMenuOpen = false"
             class="fixed inset-0 bg-black/80 backdrop-blur-sm"></div>

        <div x-show="mobileMenuOpen" 
             x-transition:enter="transition ease-in-out duration-300 transform" 
             x-transition:enter-start="-translate-x-full" 
             x-transition:enter-end="translate-x-0" 
             x-transition:leave="transition ease-in-out duration-300 transform" 
             x-transition:leave-start="translate-x-0" 
             x-transition:leave-end="-translate-x-full" 
             class="relative flex w-full max-w-xs flex-1 flex-col bg-background-dark border-r border-border-dark h-full p-6">
            
            <div class="flex items-center justify-between mb-8">
                <span class="text-lg font-black italic text-primary uppercase">Men&uacute;</span>
                <button @click="mobileMenuOpen = false" class="text-white">
                    <span class="material-symbols-outlined">close</span>
                </button>
            </div>
            <?php if(!empty($modelo['slug'])): ?>
                <div class="mb-6">
                    <a href="<?= base_url('modelo/' . $modelo['slug']) ?>" target="_blank" 
                       class="flex items-center justify-center gap-3 w-full py-4 rounded-2xl bg-gold text-black font-black uppercase tracking-widest text-[11px] shadow-lg shadow-gold/20">
                        <span class="material-symbols-outlined text-lg">visibility</span>
                        Ver Perfil P&uacute;blico
                    </a>
                </div>
            <?php endif; ?>

            <nav class="flex flex-col gap-2">
                <a @click="mobileMenuOpen = false" href="<?= base_url('modelo/dashboard') ?>" class="flex items-center gap-4 px-4 py-4 rounded-2xl bg-surface-dark border border-white/5">
                    <span class="material-symbols-outlined text-primary">dashboard</span> Dashboard
                </a>
                <a @click="mobileMenuOpen = false" href="<?= base_url('modelo/editar-ficha') ?>" class="flex items-center gap-4 px-4 py-4 rounded-2xl">
                    <span class="material-symbols-outlined text-muted">person_edit</span> Perfil
                </a>
                <a @click="mobileMenuOpen = false" href="<?= base_url('modelo/planes') ?>" class="flex items-center gap-4 px-4 py-4 rounded-2xl">
                    <span class="material-symbols-outlined text-muted">subscriptions</span> Planes
                </a>
                <a @click="mobileMenuOpen = false" href="<?= base_url('modelo/historias') ?>" class="flex items-center gap-4 px-4 py-4 rounded-2xl">
                    <span class="material-symbols-outlined text-muted">history_toggle_off</span> Historias
                </a>
            </nav>

            <div class="mt-auto border-t border-white/5 pt-6">
                <a href="<?= base_url('logout') ?>" class="flex items-center gap-4 px-4 text-primary font-bold">
                    <span class="material-symbols-outlined">logout</span> Salir
                </a>
            </div>
        </div>
    </div>

    <main class="flex flex-1 flex-col overflow-y-auto bg-background-dark custom-scrollbar">
        <div class="lg:hidden flex items-center justify-between p-4 bg-surface-dark border-b border-[#2a1d21] shrink-0 sticky top-0 z-40">
            <div class="flex items-center gap-2">
                <div class="flex h-8 w-8 items-center justify-center rounded-full bg-gradient-to-br from-primary to-gold">
                    <span class="material-symbols-outlined text-white text-lg">local_fire_department</span>
                </div>
                <span class="text-lg font-black italic tracking-tighter uppercase">Calientitas</span>
            </div>
            
            <button @click="mobileMenuOpen = true" class="text-white p-2">
                <span class="material-symbols-outlined text-3xl">menu</span>
            </button>
        </div>

        <div class="w-full">
            <?= $this->renderSection('content') ?>
        </div>
    </main>
</div>
</body>
</html>