<?= $this->extend('layouts/home_layout') ?> <?= $this->section('content') ?>

<div class="min-h-screen bg-background-dark pb-20">
    <div class="relative bg-surface-dark/50 border-b border-white/5 pt-32 pb-12 px-6 lg:px-10">
        <div class="max-w-7xl mx-auto flex flex-col md:flex-row md:items-end justify-between gap-6">
            <div>
                <div class="flex items-center gap-3 mb-2">
                    <span class="material-symbols-outlined text-primary text-3xl font-variation-settings: 'FILL' 1">favorite</span>
                    <h1 class="text-white text-4xl font-black uppercase italic tracking-tighter">Mis Favoritas</h1>
                </div>
                <p class="text-gray-500 text-sm font-medium italic">Tu selección exclusiva de las modelos más destacadas de Chile.</p>
            </div>
            
            <div class="bg-primary/10 border border-primary/20 px-6 py-3 rounded-2xl">
                <p class="text-[10px] text-primary font-black uppercase tracking-[3px] leading-none mb-1">Total Guardadas</p>
                <p class="text-white text-2xl font-black italic"><?= count($modelos) ?> <span class="text-xs uppercase opacity-50">Modelos</span></p>
            </div>
        </div>
    </div>

    <div class="max-w-7xl mx-auto px-6 lg:px-10 py-12">
        <?php if(empty($modelos)): ?>
            <div class="flex flex-col items-center justify-center py-24 text-center">
                <div class="size-24 bg-surface-dark rounded-full flex items-center justify-center mb-6 border border-white/5">
                    <span class="material-symbols-outlined text-5xl text-gray-700">heart_broken</span>
                </div>
                <h3 class="text-white text-xl font-bold uppercase tracking-tight">Aún no tienes favoritas</h3>
                <p class="text-gray-500 mt-2 mb-8 max-w-xs mx-auto">Explora el buscador y haz clic en el corazón de las modelos que más te gusten para guardarlas aquí.</p>
                <a href="<?= base_url('buscar') ?>" class="bg-white text-black px-8 py-3 rounded-xl font-black uppercase tracking-widest text-xs hover:bg-primary hover:text-white transition-all">
                    Explorar Modelos
                </a>
            </div>
        <?php else: ?>
            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-6">
                <?php foreach($modelos as $m): ?>
                    <div id="fav-card-<?= $m['id'] ?>" class="group relative flex flex-col overflow-hidden rounded-3xl bg-surface-dark border border-white/5 hover:border-primary/30 transition-all duration-500 shadow-2xl">
                        
                        <div class="relative aspect-[3/4] overflow-hidden">
                            <img src="<?= base_url('uploads/modelos/'.$m['foto_principal']) ?>" 
                                 alt="<?= $m['nombre_artistico'] ?>"
                                 class="h-full w-full object-cover transition-transform duration-700 group-hover:scale-110"
                                 onerror="this.src='<?= base_url('assets/img/placeholder.jpg') ?>'">
                            
                            <div class="absolute inset-0 bg-gradient-to-t from-background-dark via-transparent to-transparent opacity-80"></div>
                            
                            <button onclick="removerDeFavoritas(this, <?= $m['id'] ?>)" 
                                    class="absolute top-3 right-3 size-9 flex items-center justify-center rounded-xl bg-black/40 backdrop-blur-md text-primary border border-white/10 hover:bg-primary hover:text-white transition-all z-10">
                                <span class="material-symbols-outlined text-xl font-variation-settings: 'FILL' 1">favorite</span>
                            </button>
                        </div>

                        <div class="p-4">
                            <div class="flex items-center justify-between mb-1">
                                <h3 class="text-white font-black uppercase tracking-tighter italic truncate"><?= $m['nombre_artistico'] ?></h3>
                                <?php if($m['verificada']): ?>
                                    <span class="material-symbols-outlined text-emerald-400 text-sm font-variation-settings: 'FILL' 1">verified</span>
                                <?php endif; ?>
                            </div>
                            <p class="text-gray-500 text-[10px] font-bold uppercase tracking-widest flex items-center gap-1">
                                <span class="material-symbols-outlined text-[12px]">location_on</span>
                                <?= $m['ciudad_nombre'] ?? 'Chile' ?>
                            </p>
                            
                            <a href="<?= base_url('modelo/'.$m['slug']) ?>" class="mt-4 block w-full py-2 bg-white/5 hover:bg-primary text-white text-[10px] font-black uppercase tracking-[2px] text-center rounded-lg transition-all">
                                Ver Perfil
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
function removerDeFavoritas(btn, modeloId) {
    if(!confirm('¿Quitar de tus favoritas?')) return;

    fetch('<?= base_url('usuario/toggle-favorito/') ?>' + modeloId, {
        method: 'GET',
        headers: { 'X-Requested-With': 'XMLHttpRequest' }
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === 'removed') {
            const card = document.getElementById('fav-card-' + modeloId);
            card.style.opacity = '0';
            card.style.transform = 'scale(0.9)';
            setTimeout(() => {
                card.remove();
                // Si no quedan más tarjetas, recargar para mostrar el "Estado Vacío"
                if(document.querySelectorAll('[id^="fav-card-"]').length === 0) {
                    location.reload();
                }
            }, 300);
        }
    });
}
</script>

<?= $this->endSection() ?>