<?= $this->extend('layouts/home_layout') ?>

<?= $this->section('content') ?>

<div class="min-h-screen pt-32 pb-20 px-6 lg:px-10">
    <div class="max-w-6xl mx-auto">
        
        <div class="mb-12">
            <h1 class="text-4xl font-black italic uppercase tracking-tighter italic">Hola, <span class="text-primary"><?= explode(' ', session()->get('nombre'))[0] ?></span></h1>
            <p class="text-gray-500 text-sm font-medium">Bienvenido a tu centro de control privado.</p>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            
            <div class="space-y-6">
                <div class="bg-surface-dark border border-white/5 rounded-3xl p-6">
                    <nav class="space-y-2">
                        <a href="<?= base_url('usuario/panel') ?>" class="flex items-center gap-4 p-4 rounded-2xl bg-primary text-white font-bold text-sm transition-all">
                            <span class="material-symbols-outlined">dashboard</span> Resumen
                        </a>
                        <a href="<?= base_url('usuario/favoritas') ?>" class="flex items-center gap-4 p-4 rounded-2xl text-gray-400 hover:bg-white/5 hover:text-white font-bold text-sm transition-all">
                            <span class="material-symbols-outlined">favorite</span> Mis Favoritas
                        </a>
                        <a href="<?= base_url('logout') ?>" class="flex items-center gap-4 p-4 rounded-2xl text-primary/60 hover:bg-primary/5 hover:text-primary font-bold text-sm transition-all">
                            <span class="material-symbols-outlined">logout</span> Cerrar Sesin
                        </a>
                    </nav>
                </div>

                <div class="bg-gradient-to-br from-primary/20 to-transparent border border-primary/20 rounded-3xl p-8">
                    <p class="text-[10px] text-primary font-black uppercase tracking-widest mb-4">Actividad</p>
                    <div class="flex items-end gap-2">
                        <span class="text-4xl font-black italic">12</span>
                        <span class="text-xs text-gray-400 mb-2 font-bold uppercase">Visitas este mes</span>
                    </div>
                </div>
            </div>

            <div class="lg:col-span-2 space-y-8">
                
                <div class="bg-surface-dark border border-white/5 rounded-3xl p-8">
                    <h3 class="text-xl font-black uppercase italic tracking-tight mb-6 flex items-center gap-3">
                        <span class="material-symbols-outlined text-primary">settings</span> 
                        Ajustes de Cuenta
                    </h3>

                    <form action="<?= base_url('usuario/actualizar') ?>" method="POST" class="space-y-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="space-y-2">
                                <label class="text-[10px] text-gray-500 font-black uppercase tracking-widest ml-1">Nombre Completo</label>
                                <input type="text" name="nombre" value="<?= $user['nombre'] ?>" class="w-full bg-background-dark border border-white/5 rounded-xl px-4 py-3 text-sm focus:border-primary outline-none transition-all">
                            </div>
                            <div class="space-y-2">
                                <label class="text-[10px] text-gray-500 font-black uppercase tracking-widest ml-1">Correo Electrnico</label>
                                <input type="email" name="email" value="<?= $user['email'] ?>" class="w-full bg-background-dark border border-white/5 rounded-xl px-4 py-3 text-sm opacity-50 cursor-not-allowed" readonly>
                            </div>
                        </div>

                        <div class="space-y-2">
                            <label class="text-[10px] text-gray-500 font-black uppercase tracking-widest ml-1">Nueva Contrase09a (dejar en blanco para no cambiar)</label>
                            <input type="password" name="password" class="w-full bg-background-dark border border-white/5 rounded-xl px-4 py-3 text-sm focus:border-primary outline-none transition-all" placeholder="6161616161616161">
                        </div>

                        <button type="submit" class="bg-white text-black px-8 py-4 rounded-xl font-black uppercase tracking-widest text-xs hover:bg-primary hover:text-white transition-all shadow-xl shadow-black/20">
                            Guardar Cambios
                        </button>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>